/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.vo.adprofit;

import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import cn.afterturn.easypoi.excel.annotation.Excel;

import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.commons.currency.Money;

public class AdProfitMediaVo {
	@Excel(name = "ID")
	private Long id;

	/** datetime */
	@Excel(name = "日期")
	private String datetime;

	@Excel(name = "媒体名称")
	private String appName;
	
    /** appId */
	@Excel(name = "媒体ID")
    private String appId;
    
    /** indexUv */
	@Excel(name = "首页uv")
    private Integer indexUv;
    
    /** clickPv */
	@Excel(name = "点击pv")
    private Integer clickPv;
    
    /** 开发者实际消耗 */  
    private Integer consume;
	@Excel(name = "实际消耗")
    private Double consumeShow;

    /** 开发者分成收益 */  
    private Integer profitPredict;
    @Excel(name = "预估收益")
    private Double profitPredictShow;

    /** 开发者扣减金额 */  
    private Integer profitDeduct;
	@Excel(name = "扣减金额")
    private Double profitDeductShow;

    /** 开发者实际收益 */  
    private Integer profitActual;
	@Excel(name = "实际收益")
    private Double profitActualShow;

    /** 昨日预估ARPU */
	@Excel(name = "昨日预估ARPU")
    private BigDecimal yesterPredictArpu;

    /** 昨日实际ARPU */
	@Excel(name = "昨日实际ARPU")
    private BigDecimal yesterActualArpu;
	
	private BigDecimal totalActualArpu;

    /** 同步状态 */  
    private Short isUpload;

    /** 同步信息 */
	@Excel(name = "同步信息")
    private String uploadMsg;

    /** 备注 */
	@Excel(name = "备注")
    private String remark;
	
	/** 变现猫收益 */  
    private Double bxmProfitShow;
    
    
    public BigDecimal getTotalActualArpu() {
    	if ((indexUv != null && indexUv !=0) && (profitActual != null && profitActual !=0)) {
			Money money = Money.ofLi(profitActual);
			totalActualArpu = new BigDecimal(money.getYuan()).divide(
					new BigDecimal(indexUv), 2,BigDecimal.ROUND_HALF_UP);
		}
		return totalActualArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : totalActualArpu;
	}

	public void setTotalActualArpu(BigDecimal totalActualArpu) {
		this.totalActualArpu = totalActualArpu;
	}

	public Double getBxmProfitShow() {
    	if (consume != null && profitActual != null) {
			Money money = Money.ofLi(consume-profitActual);
			bxmProfitShow = money.getYuan();
		}
		return bxmProfitShow != null ? bxmProfitShow : 0.0;
	}

	public void setBxmProfitShow(Double bxmProfitShow) {
		this.bxmProfitShow = bxmProfitShow;
	}

	public String getAppName() {
		return StringUtils.isEmpty(appName) ? ReportConstant.MEDIADEFAULTMSG.MEDIADEFAULTNAME : appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public Integer getIndexUv() {
		return indexUv;
	}

	public void setIndexUv(Integer indexUv) {
		this.indexUv = indexUv;
	}

	public Integer getClickPv() {
		return clickPv;
	}

	public void setClickPv(Integer clickPv) {
		this.clickPv = clickPv;
	}

	public Double getConsumeShow() {
    	if (consume != null) {
			Money money = Money.ofLi(consume);
			consumeShow = money.getYuan();
		}
		return consumeShow != null ? consumeShow : 0.0;
	}

	public void setConsumeShow(Double consumeShow) {
		this.consumeShow = consumeShow;
	}

	public Double getProfitPredictShow() {
		if (profitPredict != null) {
			Money money = Money.ofLi(profitPredict);
			profitPredictShow = money.getYuan();
		}
		return profitPredictShow != null ? profitPredictShow : 0.0;
	}

	public void setProfitPredictShow(Double profitPredictShow) {
		this.profitPredictShow = profitPredictShow;
	}

	public Double getProfitDeductShow() {
		if (profitDeduct != null) {
			Money money = Money.ofLi(profitDeduct);
			profitDeductShow = money.getYuan();
		}
		return profitDeductShow != null ? profitDeductShow : 0.0;
	}

	public void setProfitDeductShow(Double profitDeductShow) {
		this.profitDeductShow = profitDeductShow;
	}

	public Double getProfitActualShow() {
		if (profitActual != null) {
			Money money = Money.ofLi(profitActual);
			profitActualShow = money.getYuan();
		}
		return profitActualShow != null ? profitActualShow : 0.0;
	}

	public void setProfitActualShow(Double profitActualShow) {
		this.profitActualShow = profitActualShow;
	}

	public Integer getConsume() {
		return consume;
	}

	public void setConsume(Integer consume) {
		this.consume = consume;
	}

	public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime == null ? null : datetime.trim();
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId == null ? null : appId.trim();
    }

    public Integer getProfitPredict() {
        return profitPredict;
    }

    public void setProfitPredict(Integer profitPredict) {
        this.profitPredict = profitPredict;
    }

    public Integer getProfitDeduct() {
        return profitDeduct;
    }

    public void setProfitDeduct(Integer profitDeduct) {
        this.profitDeduct = profitDeduct;
    }

    public Integer getProfitActual() {
        return profitActual;
    }

    public void setProfitActual(Integer profitActual) {
        this.profitActual = profitActual;
    }

    public BigDecimal getYesterActualArpu() {
        return yesterActualArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : yesterActualArpu;
    }

    public void setYesterActualArpu(BigDecimal yesterActualArpu) {
        this.yesterActualArpu = yesterActualArpu;
    }

    public BigDecimal getYesterPredictArpu() {
        return yesterPredictArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : yesterPredictArpu;
    }

    public void setYesterPredictArpu(BigDecimal yesterPredictArpu) {
        this.yesterPredictArpu = yesterPredictArpu;
    }

    public Short getIsUpload() {
        return isUpload;
    }

    public void setIsUpload(Short isUpload) {
        this.isUpload = isUpload;
    }

    public String getUploadMsg() {
        return uploadMsg;
    }

    public void setUploadMsg(String uploadMsg) {
        this.uploadMsg = uploadMsg == null ? null : uploadMsg.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}
    
}