/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.vo.adprofit;

import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import cn.afterturn.easypoi.excel.annotation.Excel;

import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.commons.currency.Money;

public class AdProfitPositionVo {
	@Excel(name = "ID")
    private Long id;

    /** datetime */
	@Excel(name = "日期")
    private String datetime;

	@Excel(name = "媒体ID")
	private String appId;

	@Excel(name = "媒体名称")
	private String appName;

    /** positionId */
	@Excel(name = "广告位ID")
    private String positionId;

	@Excel(name = "UV")
	private Integer indexUv;
	@Excel(name = "点击量")
	private Integer clickPv;

	private Integer positionIncome;
	@Excel(name = "广告券消耗")
	private Double positionIncomeShow;
	@Excel(name = "UVARPU")
	private Double uvArpu;
	/** 预估收入 */
	private Integer profitPredict;
	@Excel(name = "预估收益")
	private Double profitPredictShow;
	@Excel(name = "单活动领券大于8")
	private BigDecimal safeRate1;
	@Excel(name = "两次参与间隔小1s")
	private BigDecimal safeRate2;
	
    /** 预估作弊金额 */  
    private Integer profitCheat;
	@Excel(name = "预估作弊金额")
    private Double profitCheatShow;

    /** 实际扣量金额 */  
    private Integer profitDeduct;
	@Excel(name = "扣量金额")
    private Double profitDeductShow;

    /** 实际收益 */  
    private Integer profitActual;
	@Excel(name = "实际收益")
    private Double profitActualShow;

    /** 昨日预估ARPU */
	@Excel(name = "昨日预估ARPU")
    private BigDecimal yesterPredictArpu;

    /** 昨日实际ARPU */
	@Excel(name = "昨日实际ARPU")
    private BigDecimal yesterActualArpu;


	/**
	 * 活动参与率
	 */
	@Excel(name = "活动参与率")
	private Double joinRate;

	/**
	 * 广告券点击率
	 */
	@Excel(name = "广告券点击率")
	private Double clickRate;
	
	private BigDecimal totalActualArpu;

    /** remark */
	@Excel(name = "备注")
    private String remark;

    /** isImport */  
    private Short isImport;

    /** 录入状态 */  
    private Short isUpload;
    
    private String positionName;
    
    /**
     * 近7天arpu
     */
    private Double near7dayArpu;
    
    /**
     *CVR对比 
     */
    private String validClickRateContrast;
    
    /**
     * 广告位质量因子
     */
    @Excel(name = "质量因子")
    private String factor;

	private Date modifyTime;
    
    public BigDecimal getSafeRate1() {
		return safeRate1;
	}

	public void setSafeRate1(BigDecimal safeRate1) {
		this.safeRate1 = safeRate1;
	}

	public BigDecimal getSafeRate2() {
		return safeRate2;
	}

	public void setSafeRate2(BigDecimal safeRate2) {
		this.safeRate2 = safeRate2;
	}

	public BigDecimal getTotalActualArpu() {
    	if ((indexUv != null && indexUv !=0) && (profitActual != null && profitActual !=0)){
			Money money = Money.ofLi(profitActual);
			totalActualArpu = new BigDecimal(money.getYuan()).divide(
					new BigDecimal(indexUv), 2,BigDecimal.ROUND_HALF_UP);
		}
		return totalActualArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : totalActualArpu;
	}

	public void setTotalActualArpu(BigDecimal totalActualArpu) {
		this.totalActualArpu = totalActualArpu;
	}
    
    public Double getProfitCheatShow() {
    	if (profitCheat != null) {
			Money money = Money.ofLi(profitCheat);
			profitCheatShow = money.getYuan();
		}
		return profitCheatShow != null ? profitCheatShow : 0.0;
	}

	public void setProfitCheatShow(Double profitCheatShow) {
		this.profitCheatShow = profitCheatShow;
	}

	public Double getProfitPredictShow() {
		if (profitPredict != null) {
			Money money = Money.ofLi(profitPredict);
			profitPredictShow = money.getYuan();
		}
		return profitPredictShow != null ? profitPredictShow : 0.0;
	}

	public void setProfitPredictShow(Double profitPredictShow) {
		this.profitPredictShow = profitPredictShow;
	}

	public Double getProfitDeductShow() {
		if (profitDeduct != null) {
			Money money = Money.ofLi(profitDeduct);
			profitDeductShow = money.getYuan();
		}
		return profitDeductShow != null ? profitDeductShow : 0.0;
	}

	public void setProfitDeductShow(Double profitDeductShow) {
		this.profitDeductShow = profitDeductShow;
	}

	public Double getProfitActualShow() {
		if (profitActual != null) {
			Money money = Money.ofLi(profitActual);
			profitActualShow = money.getYuan();
		}
		return profitActualShow != null ? profitActualShow : 0.0;
	}

	public void setProfitActualShow(Double profitActualShow) {
		this.profitActualShow = profitActualShow;
	}

	public Integer getPositionIncome() {
		return positionIncome;
	}

	public void setPositionIncome(Integer positionIncome) {
		this.positionIncome = positionIncome;
	}

	public Double getPositionIncomeShow() {
		if (positionIncome != null) {
			Money money = Money.ofLi(positionIncome);
			profitActualShow = money.getYuan();
		}
		return profitActualShow != null ? profitActualShow : 0.0;
	}

	public void setPositionIncomeShow(Double positionIncomeShow) {
		this.positionIncomeShow = positionIncomeShow;
	}

	public Integer getIndexUv() {
		return indexUv;
	}

	public void setIndexUv(Integer indexUv) {
		this.indexUv = indexUv;
	}

	public Integer getClickPv() {
		return clickPv;
	}

	public void setClickPv(Integer clickPv) {
		this.clickPv = clickPv;
	}

	public String getPositionName() {
		return StringUtils.isEmpty(positionName) ? ReportConstant.MEDIADEFAULTMSG.POSITIONDEFAULTNAME : positionName;
	}

	public String getAppName() {
		return StringUtils.isEmpty(appName) ? ReportConstant.MEDIADEFAULTMSG.MEDIADEFAULTNAME : appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime == null ? null : datetime.trim();
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId == null ? null : positionId.trim();
    }

    public Integer getProfitCheat() {
        return profitCheat;
    }

    public void setProfitCheat(Integer profitCheat) {
        this.profitCheat = profitCheat;
    }

    public Integer getProfitPredict() {
        return profitPredict;
    }

    public void setProfitPredict(Integer profitPredict) {
        this.profitPredict = profitPredict;
    }

    public Integer getProfitDeduct() {
        return profitDeduct;
    }

    public void setProfitDeduct(Integer profitDeduct) {
        this.profitDeduct = profitDeduct;
    }

    public Integer getProfitActual() {
        return profitActual;
    }

    public void setProfitActual(Integer profitActual) {
        this.profitActual = profitActual;
    }

    public BigDecimal getYesterPredictArpu() {
        return yesterPredictArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : yesterPredictArpu;
    }

    public void setYesterPredictArpu(BigDecimal yesterPredictArpu) {
        this.yesterPredictArpu = yesterPredictArpu;
    }

    public BigDecimal getYesterActualArpu() {
        return yesterActualArpu == null ? ReportConstant.MEDIADEFAULTMSG.DEFAULTARPU : yesterActualArpu;
    }

    public void setYesterActualArpu(BigDecimal yesterActualArpu) {
        this.yesterActualArpu = yesterActualArpu;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Short getIsImport() {
        return isImport;
    }

    public void setIsImport(Short isImport) {
        this.isImport = isImport;
    }

    public Short getIsUpload() {
        return isUpload;
    }

    public void setIsUpload(Short isUpload) {
        this.isUpload = isUpload;
    }

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Double getJoinRate() {
		return null==joinRate?0:joinRate;
	}

	public void setJoinRate(Double joinRate) {
		this.joinRate = joinRate;
	}

	public Double getClickRate() {
		return null==clickRate?0:clickRate;
	}

	public void setClickRate(Double clickRate) {
		this.clickRate = clickRate;
	}

	public Double getUvArpu() {
		return uvArpu;
	}

	public void setUvArpu(Double uvArpu) {
		this.uvArpu = uvArpu;
	}

    public String getValidClickRateContrast() {
        return validClickRateContrast;
    }

    public void setValidClickRateContrast(String validClickRateContrast) {
        this.validClickRateContrast = validClickRateContrast;
    }

    public Double getNear7dayArpu() {
        return near7dayArpu;
    }

    public void setNear7dayArpu(Double near7dayArpu) {
        this.near7dayArpu = near7dayArpu;
    }

    public String getFactor() {
        return factor;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

	public Date getModifyTime() {
		return modifyTime;
	}

	public void setModifyTime(Date modifyTime) {
		this.modifyTime = modifyTime;
	}
}