package com.bxm.adsmanager.model.vo.adprofit;

import com.bxm.commons.currency.Money;

import java.io.Serializable;

/**
 * <p>开发者收益接口相关返回值VO类</p>
 *
 * @Description:
 * @Author: JandMin
 * @Date: 2018/6/11
 */
public class DeveloperProfitVo implements Serializable{

    private static final long serialVersionUID = 8171481992333513954L;

    /**
     * 帐户类型：0 非预付, 1 预付
     */
    public static final int UN_ADVANCE = 0;
    public static final int ADVANCE = 1;
    /**
     * appkey
     */
    private String appId;
    /**
     * 开发者名称
     */
    private String appName;
    /**
     * 结算日期
     */
    private String dateTime;
    /**
     * 结算金额
     */
    private long settled_Profit;
    private Double settledProfit;
    /**
     * 未结算金额
     */
    private Double unSettledProfit;
    /**
     * 扣款金额
     */
    private long deduct_Profit;
    private Double deductProfit;
    /**
     * 总金额
     */
    private Double totalProfit;
    /**
     * 帐户预付类型
     */
    private int advanceType;
    private String advanceTypeStr;
    /**
     * 扣款备注
     */
    private String remark;

    public static enum DeveloperAdvanceType{
        ADVANCE(DeveloperProfitVo.ADVANCE,"预付"),
        UN_ADVANCE(DeveloperProfitVo.UN_ADVANCE,"非预付");

        private int type;
        private String name;
        DeveloperAdvanceType(int type,String name){
            this.type = type;
            this.name = name;
        }

        public static String getName(int type){
            for (DeveloperAdvanceType develop : DeveloperAdvanceType.values()){
                if(type == develop.type){
                    return develop.name;
                }
            }
            return "-";
        }
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getAdvanceType() {
        return advanceType;
    }

    public void setAdvanceType(int advanceType) {
        this.advanceType = advanceType;
    }

    public String getAdvanceTypeStr() {
        return advanceTypeStr;
    }

    public void setAdvanceTypeStr(String advanceTypeStr) {
        this.advanceTypeStr = advanceTypeStr;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public long getSettled_Profit() {
        return settled_Profit;
    }

    public void setSettled_Profit(long settled_Profit) {
        this.settled_Profit = settled_Profit;
    }

    public Double getSettledProfit() {
        return Money.ofLi(getSettled_Profit()).getYuan();
    }

    public void setSettledProfit(Double settledProfit) {
        this.settledProfit = settledProfit;
    }

    public Double getUnSettledProfit() {
        return unSettledProfit;
    }

    public void setUnSettledProfit(Double unSettledProfit) {
        this.unSettledProfit = unSettledProfit;
    }

    public long getDeduct_Profit() {
        return deduct_Profit;
    }

    public void setDeduct_Profit(long deduct_Profit) {
        this.deduct_Profit = deduct_Profit;
    }

    public Double getDeductProfit() {
        return Money.ofLi(getDeduct_Profit()).getYuan();
    }

    public void setDeductProfit(Double deductProfit) {
        this.deductProfit = deductProfit;
    }

    public Double getTotalProfit() {
        return totalProfit;
    }

    public void setTotalProfit(Double totalProfit) {
        this.totalProfit = totalProfit;
    }
}
