package com.bxm.adsmanager.model.vo.advertiser;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description 站内户权重详情
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/12 18:06
 */
@Data
public class TblStationUserWeightDetailVO implements Serializable {

    private static final long serialVersionUID = 1425230950849209144L;

    /**
     * 权重计划ID
     */
    private Long id;

    /**
     * 广告主ID
     */
    private Long advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 提权广告类型
     */
    private Integer ticketTagCode;

    /**
     * 提权广告分类标签，完整标签路径
     */
    private String[] ticketTagCodeFullPath;

    /**
     * 是否限制流量包？ 1Y 0N
     */
    private Boolean limitFlowPackageFlag;

    /**
     * 流量包ID,  以逗号分隔的流量包ID字符串
     */
    private String flowPackageIdsStr;

    /**
     * 流量包简介信息
     */
    private String flowPackageInfoJsonStr;

    /**
     * 权重系数
     */
    private Double weightCoefficient;

    /**
     * 计划提权后券消耗额度
     */
    private BigDecimal weightPlanConsume;


}
