package com.bxm.adsmanager.model.vo.advertiser;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Description 站内户权重数据列表 页面实体类
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/11 14:37
 */
@Data
public class TblStationUserWeightVO implements Serializable {

    private static final long serialVersionUID = 713425101652765781L;

    /** */
    private Long id;

    /**
     * 广告主ID
     */
    private Long advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 销售
     */
    private String sale;

    /**
     * 提权广告类型CODE
     */
    private Integer ticketTagCode;

    /**
     * 提权广告类型名称
     */
    private String ticketTagName;

    /**
     * 提取广告数量
     */
    private Integer ticketCount;

    /**
     * 流量包数量
     */
    private Integer flowPackageCount;

    /**
     * 权重系数
     */
    private Double weightCoefficient;

    /**
     * 计划提权后券消耗额度
     */
    private BigDecimal weightPlanConsume;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 实时消耗
     */
    private BigDecimal realTimeConsume;
}
