package com.bxm.adsmanager.model.vo.bes;

import java.io.Serializable;

import lombok.Data;

/**
 * adx广告主信息.</br>
 * Created by zhengwangeng on 2021/9/1
 */
@Data
public class BesAdvertiserInfoDetailVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 广告主ID
     */
    private Integer advertiserId;

    /**
     * 公司名称
     */
    private String company;

    /**
     * 账户类型：0直客，1代理，默认0直客
     */
    private Byte accountType;

    /**
     * ADX广告主类型
     */
    private Integer adxAdvertiserType;

    /**
     * ADX方广告主ID，美团提交审核后即可获得
     */
    private String adxAdvertiserId;

    /**
     * 资质审核状态 0：审核通过；1：审核中；2：审核拒绝；3：缺省状态）
     */
    private Integer auditState;

    /**
     * 广告主主体资质名称
     */
    private String advertiserName;

    /**
     * 网站名
     */
    private String siteName;

    /**
     * 网站URL
     */
    private String siteUrl;

    /**
     * 资质类型
     */
    private Integer licenceType;

    /**
     * 营业执照注册号
     */
    private String businessLicenseNo;

    /**
     * 补充的资质图片地址，多个用逗号分隔
     */
    private String supplementLicenseImg;
}
