package com.bxm.adsmanager.model.vo.bes;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * adx广告主信息.</br>
 * Created by zhengwangeng on 2021/9/1
 */
@Data
public class BesAdvertiserInfoListVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 广告主ID
     */
    private Integer advertiserId;

    /**
     * 公司名称
     */
    private String company;

    /**
     * 账户类型：0直客，1代理，默认0直客
     */
    private Byte accountType;

    /**
     * 资质审核状态 0：审核通过；1：审核中；2：审核拒绝；3：缺省状态）
     */
    private Integer auditState;

    ///**
    // * 广告主logo
    // */
    //private String logo;
    //
    ///**
    // * 公司名
    // */
    //private String company;
    //
    ///**
    // * 公司地址
    // */
    //private String address;
    //
    //
    //private String advertiserName;
    //
    //private String siteName;
    //
    //private String siteUrl;
    //
    //private Integer licenceType;

    /**
     * ADX方广告主ID，美团提交审核后即可获得
     */
    private String adxAdvertiserId;
}
