package com.bxm.adsmanager.model.vo.media;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * Description 运营后台-广告位详情
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/24 20:26
 */
@Data
public class AppEntranceForAdsmanagerVO implements Serializable {

    private static final long serialVersionUID = 2625165451799173562L;

    /**
     * 广告位 主键id
     */
    private Long id;

    /**
     * 开发者应用ID
     */
    private Integer providerId;
    private String appKey;
    /**
     * appKey
     */
    /**
     * app名称
     */
    private String appName;

    /**
     * app入口名称(开发者配置)
     */
    private String appEntranceName;

    /**
     * app入口id(开发者配置)
     */
    private String appEntranceId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 别名
     */
    private String alias;

    /**
     * 广告位id标识
     */
    private String positionId;
    /**
     * 媒体类型
     */
    private String mediaType;

    /**
     * 媒体分类id
     * 媒体分类名称
     */
    private String mediaClassId;
    private String mediaClassName;

    /**
     * 媒体子分类id
     * 媒体子分类名称
     */
    private String mediaChildClassId;
    private String mediaChildClassName;

    /**
     * 对接方式：0获取链接,1JS对接,2API对接,3SDK对接，默认0
     */
    private Integer dockingMethod;

    /**
     * 素材图片尺寸
     */
    private String imageSize;

    /**
     * 广告位状态：0审核中,1已通过,2已拒绝，默认0
     */
    private Integer state;

    /**
     * 审核不通过原因
     */
    private String refuseReason;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date created;

    /**
     * 媒体创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date providerAppCreateTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date modified;

    /**
     * 媒介
     */
    private String medium;

    /**
     * 上线时间
     */
    private String onlineTime;
}
