package com.bxm.adsmanager.model.vo.media;

import java.io.Serializable;

import lombok.Data;

/**
 * Description TODO
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/24 14:20
 */
@Data
public class ProviderForAdsmanagerVO implements Serializable {

    private static final long serialVersionUID = -8897263346168757671L;
    /**
     * appKey， 媒体名称
     */
    private String appkey;
    private String appname;

    /**
     * 商务名称，商务code
     */
    private String bdText;
    private String bdcode;

    /**
     * 子链接个数
     */
    private Integer businessCount;

    /**
     * 媒介名称， 媒介code
     */
    private String mjText;
    private String mjcode;

    /**
     * 编号，自增
     */
    private Integer number;

    /**
     * 是否预付
     */
    private Integer advanceType;
    private Boolean prepay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 客户类型，0：直客，1：代理，2：子账号
     */
    private Integer accountType;

    /**
     * 账号类型， 1：其他帐号/原来的账号类型都是其他， 2：ADX账号
     */
    private Integer providerAccountType;

    /**
     * 1快手
     */
    private Byte rtbType;

    /**
     * 是否允许投放ocpr    1允许  0或者空 都是不允许
     */
    private Byte allowOcpr;

    /**
     * 数据查看角色
     */
    private String dataViewingRole;
    /**
     * 主域名
     */
    private String domain;

    /**
     * 开发者id
     */
    private Long providerId;

    /**
     * 申明内容
     * 活动规则
     * 活动说明
     * 活动声明（默认不前置）
     */
    private String intro;
    private String actRule;
    private String actExplain;
    private Byte activityStatement;

    /**
     * 地区类型 0：国内 1：海外 默认国内
     */
    private Integer areaType;

    private String wbAppId;

    private String wbappCodeUrl;

    /**
     * 快手appId
     */
    private String kuaishouAppId;

    /**
     * 快手密钥
     */
    private String kuaishouSecret;

    /**
     * 快手回调地址
     */
    private String kuaishouCallbackUrl;

}
