package com.bxm.adsmanager.model.vo.mobile;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/1 9:56
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
@Data
public class AdTicketMobileVO implements Serializable {

    private static final long serialVersionUID = 167964023616671758L;

    /**
     * 广告券ID, 名称, 广告主ID, 广告主名称, 广告券状态
     */
    private Long id;
    private String name;
    private Long advertiser;
    private String advertiserName;
    private String status;


    /**
     * 结算方式, 是否支持OCPC(0- 不支持、1- 支持), 日预算, 单价, 账户余额
     */
    private Short settleType;
    private Integer isSupportOcpc;
    private Double budgetDaily;
    private Double price;
    private BigDecimal advertiserBalance;

    /**
     * 曝光量(发券量), 点击量, 点击率, 消耗量
     */
    private Integer openPv;
    private Integer clickPv;
    private Double clickRate;
    private Double consume;
    private Integer validClick;

    /**
     * 是否标红, 1:需要标红， 0:不需要
     */
    private Integer needBeRedFlag;


    public AdTicketMobileVO() {
        this.budgetDaily = 0.0;
        this.price = 0.00;
        this.advertiserBalance = BigDecimal.ZERO;

        this.openPv = 0;
        this.clickPv = 0;
        this.clickRate = 0.00;
        this.consume = 0.00;
        this.validClick = 0;

        this.needBeRedFlag = 0;
    }
}
