package com.bxm.adsmanager.model.vo.monitor;
import java.io.Serializable;

import cn.afterturn.easypoi.excel.annotation.Excel;

/**
* @Title:PositionSpareTicketVo.java
* @Package:com.bxm.adsmanager.model.vo.monitor
* @Description: 广告位备用券实体类
* @date:2018年10月5日 下午2:31:23
* @author wangchao
 */
public class PositionSpareTicketVo implements Serializable{
    
    private static final long serialVersionUID = 616816185256376469L;

    /**
     * 广告位ID
     */
    @Excel(name = "广告位ID")
    private String positionId;
    
    /**
     * 媒体名称
     */
    @Excel(name = "媒体名称")
    private String appName;
    
    /**
     * 广告位名称
     */
    @Excel(name = "广告位名称")
    private String appEntranceName;
    
    /**
     * 媒介
     */
    @Excel(name = "媒介")
    private String medium;
    
    
    /**
     * 媒介code
     */
    private String mediumCode;
    
    /**
     * 发券量
     */
    @Excel(name = "发券量")
    private Double openPv;
    
    /**
     * 备用券发券占比
     */
    private Double spareOpenProportion;
    
    /**
     * 备用券发券占比(加百分号)
     */
    @Excel(name = "备用券发券占比")
    private String spareOpenProportionStr;
    
    /**
     * 阈值备用券发券占比(最大)
     */
    private Double thresholdSpareOpenProportionMax;
    
    /**
     * 监控时间段,近多少小时
     */
    private Integer monitorPeriod;
    
    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getMedium() {
        return medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public Double getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getSpareOpenProportion() {
        return spareOpenProportion;
    }

    public void setSpareOpenProportion(Double spareOpenProportion) {
        this.spareOpenProportion = spareOpenProportion;
    }

    public String getSpareOpenProportionStr() {
        return spareOpenProportionStr = spareOpenProportion !=null?(spareOpenProportion +"%"):"0.0%";
    }

    public void setSpareOpenProportionStr(String spareOpenProportionStr) {
        this.spareOpenProportionStr = spareOpenProportionStr;
    }

    public String getMediumCode() {
        return mediumCode;
    }

    public void setMediumCode(String mediumCode) {
        this.mediumCode = mediumCode;
    }

    public Double getThresholdSpareOpenProportionMax() {
        return thresholdSpareOpenProportionMax;
    }

    public void setThresholdSpareOpenProportionMax(Double thresholdSpareOpenProportionMax) {
        this.thresholdSpareOpenProportionMax = thresholdSpareOpenProportionMax;
    }

    public Integer getMonitorPeriod() {
        return monitorPeriod;
    }

    public void setMonitorPeriod(Integer monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }
    

}
