package com.bxm.adsmanager.model.vo.monitor;
import java.io.Serializable;

import cn.afterturn.easypoi.excel.annotation.Excel;

/**
* @Title:TicketUrlVo.java
* @Package:com.bxm.adsmanager.model.vo.monitor
* @Description: 券落地页实体类
* @date:2018年10月8日 下午2:30:08
* @author wangchao
 */
public class TicketUrlVo implements Serializable{

    private static final long serialVersionUID = -6363534941484385412L;

    /**
     * 广告ID
     */
    @Excel(name = "广告ID")
    private Long certificateId;
     
    /**
     * 广告名称
     */
    @Excel(name = "广告名称")
    private String shopsname;
    
    /**
     * 所属广告主
     */
    @Excel(name = "所属广告主")
    private String company;
    
    /**
     * 广告主id
     */
    private Long advertiserId;
    
    /**
     * AE
     */
    @Excel(name = "AE")
    private String ae;
    
    /**
     * AE编码
     */
    private String aeCode;
    
    /**
     *所属环境 
     */
    @Excel(name = "所属环境")
    private String environment;
    /**
     * 点击量
     */
    @Excel(name = "点击量")
    private Double clickPv;
    
    /**
     * 落地页打开耗时
     */
    @Excel(name = "落地页打开耗时")
    private String wasteTime;
    
    /**
     * 落地页到达率
     */
    
    private Double exposureRate;
    
    /**
     * 落地页到达率(加百分号)
     */
    @Excel(name = "落地页到达率")
    private String exposureRateStr;
    
    
    /**
     * 阈值落地页到达率(最大)
     */
    private Double thresholdExposureRateMax;
    
    /**
     * 监控时间段,近多少小时
     */
    private Integer monitorPeriod;
    
    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public Double getClickPv() {
        return clickPv;
    }

    public void setClickPv(Double clickPv) {
        this.clickPv = clickPv;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateStr() {
        return exposureRateStr = exposureRate !=null?(exposureRate +"%"):"0.0%";
    }

    public void setExposureRateStr(String exposureRateStr) {
        this.exposureRateStr = exposureRateStr;
    }

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public String getAeCode() {
        return aeCode;
    }

    public void setAeCode(String aeCode) {
        this.aeCode = aeCode;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getWasteTime() {
        return wasteTime;
    }

    public void setWasteTime(String wasteTime) {
        this.wasteTime = wasteTime;
    }

    public Double getThresholdExposureRateMax() {
        return thresholdExposureRateMax;
    }

    public void setThresholdExposureRateMax(Double thresholdExposureRateMax) {
        this.thresholdExposureRateMax = thresholdExposureRateMax;
    }

    public Integer getMonitorPeriod() {
        return monitorPeriod;
    }

    public void setMonitorPeriod(Integer monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }
    
}
