package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;

/**
 * 活动报表
 *
 * @author zhangkai
 * @create 2018-02-28 16:14
 **/
public class ActivityVo {

    /**
     * 编号
     */
    @Excel(name = "编号")
    private String number;
    /**
     * 活动ID
     */
    @Excel(name ="活动ID")
    private Long activityId;

    /**
     * 活动名称
     */
    @Excel(name ="活动名称")
    private String activityName;

    /**
     * 活动类型名称
     */
    @Excel(name ="活动类型")
    private String activityModelName;

    /**
     * 活动首页 PV
     */
    @Excel(name ="活动首页 PV",type = 10)
    private Integer indexPv;

    /**
     * 活动首页 PV 涨幅
     */
    @Excel(name ="活动首页 PV 涨幅")
    private String indexPvChange;

    /**
     * 活动首页 UV
     */
    @Excel(name ="活动首页 UV",type = 10)
    private Integer indexUv;

    /**
     * 活动首页 UV 涨幅
     */
    @Excel(name ="活动首页 UV 涨幅")
    private String indexUvChange;

    /**
     * 参与次数
     */
    @Excel(name ="参与次数",type = 10)
    private Integer joinPv;


    /**
     * 参与次数涨幅
     */
    @Excel(name ="参与次数涨幅")
    private String joinPvChange;

    /**
     * 参与人数
     */
    @Excel(name ="参与人数",type = 10)
    private Integer joinUv;

    /**
     * 参与人数涨幅
     */
    @Excel(name ="参与人数涨幅")
    private String joinUvChange;

    /**
     * 参与率
     */

    private Double joinRate;
    @Excel(name ="参与率")
    private String joinRateShow;

    /**
     * 参与率涨幅
     */
    @Excel(name ="参与率涨幅")
    private String joinRateChange;

    /**
     * 发券请求
     */
    @Excel(name ="发券请求",type = 10)
    private Integer sendPv;
    /**
     * 发券请求涨幅
     */
    @Excel(name ="发券请求涨幅")
    private String sendPvChange;


    /**
     * 人均发券
     */
    @Excel(name ="人均发券",type = 10)
    private Double avgCoupons;

    /**
     * 人均发券涨幅
     */
    @Excel(name ="人均发券涨幅")
    private String avgCouponsChange;
    /**
     * 发券成功率
     */
    @Excel(name ="发券成功率")
    private String activitySuccessRateShow;

    /**
     * 发券成功率涨幅
     */
    @Excel(name ="发券成功率涨幅")
    private String activitySuccessRateChange;


    /**
     * 重复发券
     */
    @Excel(name ="重复发券",type = 10)
    private Double repeatCoupons;


    /**
     * 重复发券涨幅
     */
    @Excel(name ="重复发券涨幅")
    private String repeatCouponsChange;

    /**
     * 发券量
     */
    @Excel(name ="发券量",type = 10)
    private Integer openPv;

    /**
     * 发券量涨幅
     */
    @Excel(name ="发券量涨幅")
    private String openPvChange;

    /**
     * 点击量
     */
    @Excel(name ="点击量",type = 10)
    private Integer clickPv;

    /**
     * 活动策划
     */
    @Excel(name = "活动策划")
    private String activityPlanner;
    /**
     * 人均点击量=人均券点击
     */
    @Excel(name = "人均点击量",type = 10)
    private Double perClickPv;
    /**
     * 人均点击量环比昨日
     */
    @Excel(name = "人均点击量")
    private String perClickPvChange;



    /**
     * 点击量涨幅
     */
    @Excel(name ="点击量涨幅")
    private String clickPvChange;

    public String getJoinRateShow() {
        return joinRateShow;
    }

    public void setJoinRateShow(String joinRateShow) {
        this.joinRateShow = joinRateShow;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityModelName() {
        return activityModelName;
    }

    public void setActivityModelName(String activityModelName) {
        this.activityModelName = activityModelName;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public String getIndexPvChange() {
        return indexPvChange;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public String getIndexUvChange() {
        return indexUvChange;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Integer getJoinPv() {
        return joinPv;
    }

    public void setJoinPv(Integer joinPv) {
        this.joinPv = joinPv;
    }

    public String getJoinPvChange() {
        return joinPvChange;
    }

    public void setJoinPvChange(String joinPvChange) {
        this.joinPvChange = joinPvChange;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public String getJoinUvChange() {
        return joinUvChange;
    }

    public void setJoinUvChange(String joinUvChange) {
        this.joinUvChange = joinUvChange;
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public String getJoinRateChange() {
        return joinRateChange;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Double getAvgCoupons() {
        return avgCoupons;
    }

    public void setAvgCoupons(Double avgCoupons) {
        this.avgCoupons = avgCoupons;
    }

    public String getAvgCouponsChange() {
        return avgCouponsChange;
    }

    public void setAvgCouponsChange(String avgCouponsChange) {
        this.avgCouponsChange = avgCouponsChange;
    }

    public Double getRepeatCoupons() {
        return repeatCoupons;
    }

    public void setRepeatCoupons(Double repeatCoupons) {
        this.repeatCoupons = repeatCoupons;
    }

    public String getRepeatCouponsChange() {
        return repeatCouponsChange;
    }

    public void setRepeatCouponsChange(String repeatCouponsChange) {
        this.repeatCouponsChange = repeatCouponsChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getActivitySuccessRateShow() {
        return activitySuccessRateShow;
    }

    public void setActivitySuccessRateShow(String activitySuccessRateShow) {
        this.activitySuccessRateShow = activitySuccessRateShow;
    }

    public String getActivitySuccessRateChange() {
        return activitySuccessRateChange;
    }

    public void setActivitySuccessRateChange(String activitySuccessRateChange) {
        this.activitySuccessRateChange = activitySuccessRateChange;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public Double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public String getPerClickPvChange() {
        return perClickPvChange;
    }

    public void setPerClickPvChange(String perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }
}
