package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 开发者日报-子链接-广告券-日报表
 * @author  bcc
 */
public class AppBusinessTicketDateVo implements Serializable{

    /**
     * 编号
     */
    @Excel(name = "编号")
    private String number;
    /**
     * 日期
     */
    @Excel(name="日期")
    private String datetime;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量",type = 10)
    private Integer openPv;
    /**
     * 曝光量（发券量）涨幅
     */
    @Excel(name = "发券量涨幅")
    private String openPvChange;

    @Excel(name = "点击量",type = 10)
    private Integer clickPv;

    /**
     * 点击量涨幅
     */
    @Excel(name = "点击量涨幅")
    private String clickPvChange;

    /**
     * 有效点击量
     */
    @Excel(name = "有效点击量",type = 10)
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    @Excel(name = "有效点击量涨幅")
    private String validClickChange;

    /**
     * 有效点击率
     */
    private Double validClickRate;
    @Excel(name = "有效点击率")
    private String validClickRateShow;

    /**
     * 有效点击率涨幅
     */
    @Excel(name = "有效点击率涨幅")
    private String validClickRateChange;

    /**
     * 转化率
     */
    private Double conversion;
    @Excel(name = "转化率")
    private String conversionShow;

    /**
     * 转化率涨幅
     */
    @Excel(name = "转化率涨幅")
    private String conversionChange;

    /**
     * 有效点击率占比
     */
    private Double qualityFactor;
    @Excel(name = "有效点击率占比")
    private String qualityFactorShow;

    /**
     * 有效点击率占比涨幅
     */
    @Excel(name = "有效点击率占比涨幅")
    private String qualityFactorChange;

    /**
     * 发券占比
     */
    private Double openPvRate;
    @Excel(name = "发券占比")
    private String openPvRateShow;

    /**
     * 发券占比涨幅
     */
    @Excel(name = "发券占比涨幅")
    private String openPvRateChange;

    /**
     * 券收入
     */
    @Excel(name = "券收入",type = 10)
    private Double income;
    /**
     * 券收入涨幅
     */
    @Excel(name = "券收入涨幅")
    private String incomeChange;

    /**
     * 发券aurp
     */
    @Excel(name = "发券arpu",type = 10)
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    @Excel(name = "发券arpu涨幅")
    private String openPvAurpChange;

    /**
     * 点击aurp
     */
    @Excel(name = "点击arpu",type = 10)
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    @Excel(name = "点击arpu涨幅")
    private String clickAurpChange;

    /**
     * 广告位所属流量包
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String packageName;

    /**
     * 广告位所属流量包出价
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private BigDecimal packagePrice;

    /**
     * 发券时间
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String sendTicketTime;

    /**
     * 礼券操作日志次数
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private Integer ticketOperationLog;

    /**
     * 礼券日平均权重
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private BigDecimal averageWeightByDay;

    /**
     * 礼券发券机会
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String sendTicketProbability;

    /**
     * 礼券发券的设备限制
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String equipmentConstraints;

    /**
     * 礼券发券的环境限制
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String environmentConstraints;

    /**
     * 礼券发券的地域限制
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String regionConstraints;

    /**
     * 礼券的总发券机会
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String totalSendTicketProbability;

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public BigDecimal getPackagePrice() {
        return packagePrice;
    }

    public void setPackagePrice(BigDecimal packagePrice) {
        this.packagePrice = packagePrice;
    }

    public String getSendTicketTime() {
        return sendTicketTime;
    }

    public void setSendTicketTime(String sendTicketTime) {
        this.sendTicketTime = sendTicketTime;
    }

    public Integer getTicketOperationLog() {
        return ticketOperationLog;
    }

    public void setTicketOperationLog(Integer ticketOperationLog) {
        this.ticketOperationLog = ticketOperationLog;
    }

    public BigDecimal getAverageWeightByDay() {
        return averageWeightByDay;
    }

    public void setAverageWeightByDay(BigDecimal averageWeightByDay) {
        this.averageWeightByDay = averageWeightByDay;
    }

    public String getSendTicketProbability() {
        if(sendTicketProbability == null){
            sendTicketProbability = "0.0";
        }
        return sendTicketProbability;
    }

    public void setSendTicketProbability(String sendTicketProbability) {
        this.sendTicketProbability = sendTicketProbability;
    }

    public String getEquipmentConstraints() {
        if(equipmentConstraints == null){
            equipmentConstraints = "0.0";
        }
        return equipmentConstraints ;
    }

    public void setEquipmentConstraints(String equipmentConstraints) {
        this.equipmentConstraints = equipmentConstraints;
    }

    public String getEnvironmentConstraints() {
        if(environmentConstraints == null){
            environmentConstraints = "0.0";
        }
        return environmentConstraints;
    }

    public void setEnvironmentConstraints(String environmentConstraints) {
        this.environmentConstraints = environmentConstraints;
    }

    public String getRegionConstraints() {
        if(regionConstraints == null){
            regionConstraints = "0.0";
        }
        return regionConstraints ;
    }

    public void setRegionConstraints(String regionConstraints) {
        this.regionConstraints = regionConstraints;
    }

    public String getTotalSendTicketProbability() {
        if(totalSendTicketProbability == null){
            totalSendTicketProbability = "0.0";
        }
        return totalSendTicketProbability;
    }

    public void setTotalSendTicketProbability(String totalSendTicketProbability) {
        this.totalSendTicketProbability = totalSendTicketProbability;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public String getValidClickChange() {
        return validClickChange;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public String getValidClickRateChange() {
        return validClickRateChange;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public Double getConversion() {
        return conversion;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public String getConversionChange() {
        return conversionChange;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public String getQualityFactorChange() {
        return qualityFactorChange;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public String getOpenPvRateChange() {
        return openPvRateChange;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public String getClickAurpChange() {
        return clickAurpChange;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public String getValidClickRateShow() {
        return validClickRateShow;
    }

    public void setValidClickRateShow(String validClickRateShow) {
        this.validClickRateShow = validClickRateShow;
    }

    public String getConversionShow() {
        return conversionShow;
    }

    public void setConversionShow(String conversionShow) {
        this.conversionShow = conversionShow;
    }

    public String getQualityFactorShow() {
        return qualityFactorShow;
    }

    public void setQualityFactorShow(String qualityFactorShow) {
        this.qualityFactorShow = qualityFactorShow;
    }

    public String getOpenPvRateShow() {
        return openPvRateShow;
    }

    public void setOpenPvRateShow(String openPvRateShow) {
        this.openPvRateShow = openPvRateShow;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }
}
