package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.model.base.BaseModel;
import com.bxm.adsmanager.model.annotation.ExcelReportIncrease;
import com.bxm.adsmanager.model.base.BaseExportVo;

import java.io.Serializable;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.vo.report.AppBusinessVo.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-01 17:01:00
 * @modifier ganquan
 * @updated 2018-03-01 17:01:00
 */
public class AppBusinessVo extends BaseModel implements Serializable{

    /**
     * 编号
     */
    @Excel(name = "编号")
    private String number;

    /**
     * 开发者id
     */
    @Excel(name = "开发者id")
    private Long appId;

    /**
     * 日期
     */
    @Excel(name = "日期")
    private String datetime;

    /**
     * 开发者唯一标识
     */
    @Excel(name="appKey")
    private String appKey;

    /**
     * 子链接
     */
    @Excel(name="子链接ID")
    private String business;

    /**
     * 子链接名称
     */
    @Excel(name="子链接名称")
    private String businessName;


    /**
     * 入口点击量
     */
    private Integer iconClickPv;

    /**
     * 入口点击pv环比昨日，已乘100
     */
    private String iconClickChange;

    /**
     * 中间页uv
     */
    private Integer midPageUv;

    /**
     * 中间页uv环比昨日，已乘100
     */
    private String midUvChange;

    /**
     * 中间页pv
     */
    @Excel(name="中间页 pv",type = 10)
    private Integer midPagePv;

    /**
     * 中间页pv环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "midPagePv")
    @Excel(name="中间页 pv 涨幅")
    private String midPvChange;

    /**
     * 活动首页pv
     */
    @Excel(name="活动首页pv",type = 10)
    private Integer indexPv;

    /**
     * 活动首页pv环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "indexPv")
    @Excel(name="活动首页pv涨幅")
    private String indexPvChange;

    /**
     * 活动首页uv
     */
    @Excel(name="活动首页uv",type = 10)
    private Integer indexUv;

    /**
     * 活动首页uv环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "indexUv")
    @Excel(name="活动首页uv涨幅")
    private String indexUvChange;

    /**
     * 活动参与率
     */
    private Double joinRate;
    @Excel(name="活动参与率")
    private String joinRateShow;

    /**
     * 活动参与率环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "joinRateShow")
    @Excel(name="活动参与率涨幅")
    private String joinRateChange;

    /**
     * 发券请求量
     */
    @Excel(name="发券请求量",type = 10)
    private Integer sendPv;

    /**
     * 发券请求环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "sendPv")
    @Excel(name="发券请求量涨幅")
    private String sendPvChange;

    /**
     * 发券量
     */
    @Excel(name="发券量",type = 10)
    private Integer openPv;

    /**
     * 发券量环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "openPv")
    @Excel(name="发券量涨幅")
    private String openPvChange;

    /**
     * 发券成功率
     */
    private Double successRate;
    @Excel(name="发券成功率")
    private String successRateShow;

    /**
     * 发券成功率环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "successRateShow")
    @Excel(name="发券成功率涨幅")
    private String successRateChange;

    /**
     * 安卓发券占比
     */
    private Double androidOpenRate;
    @Excel(name="安卓发券占比")
    private String androidOpenRateShow;

    /**
     * 安卓发券占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "androidOpenRateShow")
    @Excel(name="安卓发券占比涨幅")
    private String androidRateChange;

    /**
     * ios发券占比
     */
    private Double iosOpenRate;
    @Excel(name="ios发券占比")
    private String iosOpenRateShow;

    /**
     * ios发券占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "iosOpenRateShow")
    @Excel(name="ios发券占比涨幅")
    private String iosRateChange;

    /**
     * web发券占比
     */
    private Double webOpenRate;
    @Excel(name="web发券占比")
    private String webOpenRateShow;

    /**
     * web发券占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "webOpenRateShow")
    @Excel(name="web发券占比涨幅")
    private String webRateChange;

    /**
     * 微信发券占比
     */
    private Double wechatOpenRate;
    @Excel(name="微信发券占比")
    private String wechatOpenRateShow;

    /**
     * 微信发券占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "wechatOpenRateShow")
    @Excel(name="微信发券占比涨幅")
    private String wechatRateChange;

    /**
     * IMEI发券占比
     */
    private Double imeiOpenRate;
    @Excel(name="IMEI发券占比")
    private String imeiOpenRateShow;

    /**
     * IMEI发券占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "imeiOpenRateShow")
    @Excel(name="IMEI发券占比涨幅")
    private String imeiRateChange;

    /**
     * 老用户占比（当日uv中在前三天有访问记录的uv记为老用户）
     */
    private Double oldRate;
    @Excel(name="老用户占比")
    private String oldRateShow;

    /**
     * 老用户占比环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "oldRateShow")
    @Excel(name="老用户占比涨幅")
    private String oldRateChange;

    /**
     * 广告券点击率
     */

    private Double clickRate;
    @Excel(name="广告券点击率")
    private String clickRateShow;

    /**
     * 广告券点击率环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "clickRateShow")
    @Excel(name="广告券点击率涨幅")
    private String clickRateChange;

    /**
     * 人均发券量
     */
    @Excel(name="人均发券量",type = 10)
    private Double perOpenPv;

    /**
     * 人均发券环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "perOpenPv")
    @Excel(name="人均发券量涨幅")
    private String perOpenPvChange;

    /**
     * 人均重复发券
     */
    @Excel(name="人均重复发券",type = 10)
    private Double rptOpenPv;

    /**
     * 人均重复发券环比昨日，已乘100
     */
    @ExcelReportIncrease(belongField = "rptOpenPv")
    @Excel(name="人均重复发券涨幅")
    private String rptOpenPvChange;

    /**
     * 子链接收益（排序）
     */
    @Excel(name="子链接收益",type = 10)
    private Double businessIncome;

    /**
     * 子链接收益涨幅
     */
    @ExcelReportIncrease(belongField = "businessIncome")
    @Excel(name="子链接收益涨幅")
    private String businessIncomeChange;

    /**
     * 子链接UVARPU（排序）
     */
    @Excel(name="子链接UVARPU",type = 10)
    private Double businessAurp;

    /**
     * 子链接UVARPU（排序）
     */
    @Excel(name="子链接UVARPU")
    private String businessAurpChange;

    /**
     * （券收入）
     */
    @Excel(name="券收入",type = 10)
    private Double income;

    /**
     * (券收入涨幅)
     */
    @ExcelReportIncrease(belongField = "income")
    @Excel(name="券收入涨幅")
    private String incomeChange;

    /**
     * 券收入 UVAURP
     */
    @Excel(name="券收入 UVARPU ",type = 10)
    private Double incomeAurp;
    /**
     * 券收入 UVAURP 涨幅
     */
    @ExcelReportIncrease(belongField = "incomeAurp")
    @Excel(name="券收入 UVARPU涨幅")
    private String incomeAurpChange;

    /**
     * 广告位曝光数
     */
    @Excel(name="广告位曝光数",type = 10)
    private Integer iconPv;

    /**
     * 广告位曝光数涨幅
     */
    @ExcelReportIncrease(belongField = "iconPv")
    @Excel(name="广告位曝光数涨幅")
    private String iconChange;

    /**
     * 点击到达率
     */
    @Excel(name="点击到达率",type = 10)
    private Double midPageRate;
    private String midPageRateShow;

    /**
     * 点击到达率涨幅
     * */
    @ExcelReportIncrease(belongField = "midPageRate")
    @Excel(name="点击到达率涨幅")
    private String midPageRateChange;

    /**
     * 首页曝光数
     * */
    @Excel(name="首页曝光数",type = 10)
    private Integer  landingPagePv;

    /**
     * 首页曝光数涨幅
     * */
    @ExcelReportIncrease(belongField = "landingPagePv")
    @Excel(name="首页曝光数涨幅")
    private String landingPageChange;

    /**
     * 页面展现率
     * */
    @Excel(name="页面展现率",type = 10)
    private Double landingPageRate;
    private String landingPageRateShow;

    /**
     * 页面展现率涨幅
     * */
    @ExcelReportIncrease(belongField = "landingPageRate")
    @Excel(name="页面展现率涨幅")
    private String  landingRateChange;


    /**
     * ecpm（券收入除以广告位曝光数）
     * */
    @Excel(name="ecpm",type = 10)
    private Double ecpm;

    /**
     * ecpm涨幅
     * */
    @ExcelReportIncrease(belongField = "ecpm")
    @Excel(name="ecpm涨幅")
    private String ecpmChange;

    /**
     * mEcpm 媒体ecpm（子链接收益除以广告位曝光数）
     * */
    @Excel(name="媒体ecpm",type = 10)
    private Double mEcpm;

    /**
     * mEcpm涨幅
     * */
    @ExcelReportIncrease(belongField = "mEcpm")
    @Excel(name="媒体Ecpm涨幅")
    private String mEcpmChange;

    /**
     *子链接UVarpu
     * */
    @Excel(name="子链接UVarpu",type = 10)
    private Double bussinessUvArpu;

    /**
     *券收入UVArpu
     * */
    @Excel(name="券收入UVArpu",type = 10)
    private Double incomeUvArpu;

    @Excel(name = "发券arpu",type = 10)
    private Double openPvAurp;

    /**
     * 发券ARUP涨幅
     */
    @ExcelReportIncrease(belongField = "openPvAurp")
    @Excel(name = "发券arpu涨幅")
    private String openPvAurpChange;

    @Excel(name = "上线时间")
    private String onlineTime;

    @Excel(name = "人均券点击",type = 10)
    private Double perClickPv;

    @ExcelReportIncrease(belongField = "perClickPv")
    @Excel(name = "人均券点击涨幅")
    private String  perClickPvChange;

    // 20180710-positionType新增字段
    private Boolean iconPvEditable = false;     // 曝光是否可编辑
    private Boolean iconClickPvEditable = false;// 点击是否可编辑


    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public Integer getIconClickPv() {
        return iconClickPv;
    }

    public void setIconClickPv(Integer iconClickPv) {
        this.iconClickPv = iconClickPv;
    }

    public String getIconClickChange() {
        return iconClickChange;
    }

    public void setIconClickChange(String iconClickChange) {
        this.iconClickChange = iconClickChange;
    }

    public Integer getMidPageUv() {
        return midPageUv;
    }

    public void setMidPageUv(Integer midPageUv) {
        this.midPageUv = midPageUv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public String getMidUvChange() {
        return midUvChange;
    }

    public void setMidUvChange(String midUvChange) {
        this.midUvChange = midUvChange;
    }


    public String getMidPvChange() {
        return midPvChange;
    }

    public void setMidPvChange(String midPvChange) {
        this.midPvChange = midPvChange;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public String getIndexPvChange() {
        return indexPvChange;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public String getIndexUvChange() {
        return indexUvChange;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public String getJoinRateChange() {
        return joinRateChange;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Double getSuccessRate() {
        return successRate;
    }

    public void setSuccessRate(Double successRate) {
        this.successRate = successRate;
    }

    public String getSuccessRateChange() {
        return successRateChange;
    }

    public void setSuccessRateChange(String successRateChange) {
        this.successRateChange = successRateChange;
    }

    public Double getAndroidOpenRate() {
        return androidOpenRate;
    }

    public void setAndroidOpenRate(Double androidOpenRate) {
        this.androidOpenRate = androidOpenRate;
    }

    public String getAndroidRateChange() {
        return androidRateChange;
    }

    public void setAndroidRateChange(String androidRateChange) {
        this.androidRateChange = androidRateChange;
    }

    public Double getIosOpenRate() {
        return iosOpenRate;
    }

    public void setIosOpenRate(Double iosOpenRate) {
        this.iosOpenRate = iosOpenRate;
    }

    public String getIosRateChange() {
        return iosRateChange;
    }

    public void setIosRateChange(String iosRateChange) {
        this.iosRateChange = iosRateChange;
    }

    public Double getWebOpenRate() {
        return webOpenRate;
    }

    public void setWebOpenRate(Double webOpenRate) {
        this.webOpenRate = webOpenRate;
    }

    public String getWebRateChange() {
        return webRateChange;
    }

    public void setWebRateChange(String webRateChange) {
        this.webRateChange = webRateChange;
    }

    public Double getWechatOpenRate() {
        return wechatOpenRate;
    }

    public void setWechatOpenRate(Double wechatOpenRate) {
        this.wechatOpenRate = wechatOpenRate;
    }

    public String getWechatRateChange() {
        return wechatRateChange;
    }

    public void setWechatRateChange(String wechatRateChange) {
        this.wechatRateChange = wechatRateChange;
    }

    public Double getImeiOpenRate() {
        return imeiOpenRate;
    }

    public void setImeiOpenRate(Double imeiOpenRate) {
        this.imeiOpenRate = imeiOpenRate;
    }

    public String getImeiRateChange() {
        return imeiRateChange;
    }

    public void setImeiRateChange(String imeiRateChange) {
        this.imeiRateChange = imeiRateChange;
    }

    public Double getOldRate() {
        return oldRate;
    }

    public void setOldRate(Double oldRate) {
        this.oldRate = oldRate;
    }

    public String getOldRateChange() {
        return oldRateChange;
    }

    public void setOldRateChange(String oldRateChange) {
        this.oldRateChange = oldRateChange;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public String getClickRateChange() {
        return clickRateChange;
    }

    public void setClickRateChange(String clickRateChange) {
        this.clickRateChange = clickRateChange;
    }

    public Double getPerOpenPv() {
        return perOpenPv;
    }

    public void setPerOpenPv(Double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public String getPerOpenPvChange() {
        return perOpenPvChange;
    }

    public void setPerOpenPvChange(String perOpenPvChange) {
        this.perOpenPvChange = perOpenPvChange;
    }

    public Double getRptOpenPv() {
        return rptOpenPv;
    }

    public void setRptOpenPv(Double rptOpenPv) {
        this.rptOpenPv = rptOpenPv;
    }

    public String getRptOpenPvChange() {
        return rptOpenPvChange;
    }

    public void setRptOpenPvChange(String rptOpenPvChange) {
        this.rptOpenPvChange = rptOpenPvChange;
    }

    public Double getBusinessIncome() {
        return businessIncome;
    }

    public void setBusinessIncome(Double businessIncome) {
        this.businessIncome = businessIncome;
    }

    public void setBusinessAurp(Double businessAurp) {
        this.businessAurp = businessAurp;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getBusinessIncomeChange() {
        return businessIncomeChange;
    }

    public void setBusinessIncomeChange(String businessIncomeChange) {
        this.businessIncomeChange = businessIncomeChange;
    }

    public String getBusinessAurpChange() {
        return businessAurpChange;
    }

    public void setBusinessAurpChange(String businessAurpChange) {
        this.businessAurpChange = businessAurpChange;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public String getJoinRateShow() {
        return joinRateShow;
    }

    public void setJoinRateShow(String joinRateShow) {
        this.joinRateShow = joinRateShow;
    }

    public String getSuccessRateShow() {
        return successRateShow;
    }

    public void setSuccessRateShow(String successRateShow) {
        this.successRateShow = successRateShow;
    }

    public String getAndroidOpenRateShow() {
        return androidOpenRateShow;
    }

    public void setAndroidOpenRateShow(String androidOpenRateShow) {
        this.androidOpenRateShow = androidOpenRateShow;
    }

    public String getIosOpenRateShow() {
        return iosOpenRateShow;
    }

    public void setIosOpenRateShow(String iosOpenRateShow) {
        this.iosOpenRateShow = iosOpenRateShow;
    }

    public String getWebOpenRateShow() {
        return webOpenRateShow;
    }

    public void setWebOpenRateShow(String webOpenRateShow) {
        this.webOpenRateShow = webOpenRateShow;
    }

    public String getWechatOpenRateShow() {
        return wechatOpenRateShow;
    }

    public void setWechatOpenRateShow(String wechatOpenRateShow) {
        this.wechatOpenRateShow = wechatOpenRateShow;
    }

    public String getImeiOpenRateShow() {
        return imeiOpenRateShow;
    }

    public void setImeiOpenRateShow(String imeiOpenRateShow) {
        this.imeiOpenRateShow = imeiOpenRateShow;
    }

    public String getOldRateShow() {
        return oldRateShow;
    }

    public void setOldRateShow(String oldRateShow) {
        this.oldRateShow = oldRateShow;
    }

    public String getClickRateShow() {
        return clickRateShow;
    }

    public void setClickRateShow(String clickRateShow) {
        this.clickRateShow = clickRateShow;
    }

    public Double getBusinessAurp() {
        return businessAurp;
    }

    public Double getIncome() {
        return income;
    }

    public Double getIncomeAurp() {
        return incomeAurp;
    }

    public void setIncomeAurp(Double incomeAurp) {
        this.incomeAurp = incomeAurp;
    }

    public String getIncomeAurpChange() {
        return incomeAurpChange;
    }

    public void setIncomeAurpChange(String incomeAurpChange) {
        this.incomeAurpChange = incomeAurpChange;
    }

    public Integer getIconPv() {
        return iconPv;
    }

    public void setIconPv(Integer iconPv) {
        this.iconPv = iconPv;
    }

    public String getIconChange() {
        return iconChange;
    }

    public void setIconChange(String iconChange) {
        this.iconChange = iconChange;
    }

    public Double getMidPageRate() {
        return midPageRate;
    }

    public void setMidPageRate(Double midPageRate) {
        this.midPageRate = midPageRate;
    }

    public String getMidPageRateChange() {
        return midPageRateChange;
    }

    public void setMidPageRateChange(String midPageRateChange) {
        this.midPageRateChange = midPageRateChange;
    }

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public String getLandingPageChange() {
        return landingPageChange;
    }

    public void setLandingPageChange(String landingPageChange) {
        this.landingPageChange = landingPageChange;
    }

    public Double getLandingPageRate() {
        return landingPageRate;
    }

    public void setLandingPageRate(Double landingPageRate) {
        this.landingPageRate = landingPageRate;
    }

    public String getLandingRateChange() {
        return landingRateChange;
    }

    public void setLandingRateChange(String landingRateChange) {
        this.landingRateChange = landingRateChange;
    }

    public Double getEcpm() {
        return ecpm;
    }

    public void setEcpm(Double ecpm) {
        this.ecpm = ecpm;
    }

    public String getEcpmChange() {
        return ecpmChange;
    }

    public void setEcpmChange(String ecpmChange) {
        this.ecpmChange = ecpmChange;
    }

    public Double getmEcpm() {
        return mEcpm;
    }

    public void setmEcpm(Double mEcpm) {
        this.mEcpm = mEcpm;
    }

    public String getmEcpmChange() {
        return mEcpmChange;
    }

    public void setmEcpmChange(String mEcpmChange) {
        this.mEcpmChange = mEcpmChange;
    }

    public Double getBussinessUvArpu() {
        return bussinessUvArpu;
    }

    public void setBussinessUvArpu(Double bussinessUvArpu) {
        this.bussinessUvArpu = bussinessUvArpu;
    }

    public Double getIncomeUvArpu() {
        return incomeUvArpu;
    }

    public void setIncomeUvArpu(Double incomeUvArpu) {
        this.incomeUvArpu = incomeUvArpu;
    }
    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getMidPageRateShow() {
        return midPageRateShow;
    }

    public void setMidPageRateShow(String midPageRateShow) {
        this.midPageRateShow = midPageRateShow;
    }

    public String getLandingPageRateShow() {
        return landingPageRateShow;
    }

    public void setLandingPageRateShow(String landingPageRateShow) {
        this.landingPageRateShow = landingPageRateShow;
    }

    public String getOnlineTime() {
        return onlineTime;
    }

    public void setOnlineTime(String onlineTime) {
        this.onlineTime = onlineTime;
    }

    public Double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public String getPerClickPvChange() {
        return perClickPvChange;
    }

    public void setPerClickPvChange(String perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }

    public Boolean getIconPvEditable() {
        return iconPvEditable;
    }

    public void setIconPvEditable(Boolean iconPvEditable) {
        this.iconPvEditable = iconPvEditable;
    }

    public Boolean getIconClickPvEditable() {
        return iconClickPvEditable;
    }

    public void setIconClickPvEditable(Boolean iconClickPvEditable) {
        this.iconClickPvEditable = iconClickPvEditable;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public String[] getDefaultExportFields() {
        return new String[]{"number","appId","datetime","appKey","business","businessName"};
    }
}
