/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.vo.report;


import java.io.Serializable;
import java.util.List;

/**
 * 报表的分页
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.vo.report.Page.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 14:44:00
 * @modifier 阿导
 * @updated 2018-02-27 14:44:00
 */
public class Page<T> implements Serializable {


    /**
     * 自动生成的序列化 ID
     */
    private static final long serialVersionUID = 6766276588316636040L;

    /**
     * 当前页面大小
     */
    private Integer pageSize;
    /**
     * 当前页码
     */
    private Integer pageNo;
    private Integer pageNum;
    /**
     * 总条数
     */
    private Long total;
    /**
     * 总页数
     */

    private Integer pages;

    /**
     * 是否有下一页
     */
    private Boolean hasNexPage;

    /**
     * 是否有上一页
     */
    private Boolean hasPrePage;

    /**
     * 是否为第一页
     */
    private Boolean isFirstPage;

    /**
     * 是否为最后一页
     */
    private Boolean isLastPage;

    /**
     * 当前页大小
     */
    private Integer size;

    /**
     * 结果集
     */
    private List<T> list;

    public Page() {
    }

    public Page(List<T> list, Integer pageNo, Integer pageSize, Long total) {
        this(list, pageNo, pageSize, total, false);
    }

    public Page(List<T> list, Integer pageNo, Integer pageSize, Long total, Boolean hasCount) {
        if (list == null && total == null) {
            this.list = null;
            this.pageNo = pageNo;
            this.pageSize = pageSize;
            this.total = 0L;
            this.size = 0;
            this.pages = 0;
        } else {
            this.list = list;
            this.pageNo = pageNo;
            this.pageSize = pageSize;
            this.total = total;
            if (hasCount) {
                this.size = list.size() != 0 ? list.size() - 1 : 0;
            } else {
                this.size = list.size();
            }
            this.pages = Integer.valueOf(String.valueOf(Math.ceil(total / (double) pageSize)).split("\\.")[0]);
        }
        if (pageNo == 1) {
            this.isFirstPage = true;
        } else {
            this.isFirstPage = false;
        }
        if (pageNo .equals( this.pages)) {
            this.isLastPage = true;
        } else {
            this.isLastPage = false;
        }

        if (pages > pageNo) {
            this.hasNexPage = true;
        } else {
            this.hasNexPage = false;
        }
        if (pageNo > 1) {
            this.hasPrePage = true;
        } else {
            this.hasPrePage = false;
        }
    }


    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
        this.pageNum = pageNo;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
        this.pageNo = pageNum;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Integer getPages() {
        return pages;
    }

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public Boolean getHasNexPage() {
        return hasNexPage;
    }

    public void setHasNexPage(Boolean hasNexPage) {
        this.hasNexPage = hasNexPage;
    }

    public Boolean getHasPrePage() {
        return hasPrePage;
    }

    public void setHasPrePage(Boolean hasPrePage) {
        this.hasPrePage = hasPrePage;
    }

    public Boolean getFirstPage() {
        return isFirstPage;
    }

    public void setFirstPage(Boolean firstPage) {
        isFirstPage = firstPage;
    }

    public Boolean getLastPage() {
        return isLastPage;
    }

    public void setLastPage(Boolean lastPage) {
        isLastPage = lastPage;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}
