package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.model.annotation.ExcelReportIncrease;
import com.bxm.adsmanager.model.base.BaseExportVo;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.vo.report.TicketAppVo.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-02 19:33:00
 * @modifier ganquan
 * @updated 2018-03-02 19:33:00
 */
public class TicketAppVo extends BaseExportVo {

    /**
     * 编号
     */
    @Excel(name = "编号")
    private String number;

    /**
     * 开发者唯一标识
     */
    @Excel(name = "开发者唯一标识")
    private String appKey;

    /**
     * 开发者名称
     */
    @Excel(name = "开发者名称")
    private String appName;

    /**
     * 子链接数
     */
    @Excel(name = "子链接数",type = 10)
    private String businessNumber;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量",type = 10)
    private Integer openPv;
    /**
     * 曝光量（发券量）涨幅
     */
    @ExcelReportIncrease(belongField = "openPv")
    @Excel(name = "发券量涨幅")
    private String openPvChange;

    @Excel(name = "点击量",type = 10)
    private Integer clickPv;

    /**
     * 点击量涨幅
     */
    @ExcelReportIncrease(belongField = "clickPv")
    @Excel(name = "点击量涨幅")
    private String clickPvChange;

    /**
     * 有效点击量
     */
    @Excel(name = "有效点击量",type = 10)
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    @ExcelReportIncrease(belongField = "validClick")
    @Excel(name = "有效点击量涨幅")
    private String validClickChange;

    /**
     * 有效点击率 -- > CVR
     */
    private Double validClickRate;
    @Excel(name = "CVR")
    private String validClickRateShow;


    /**
     * 有效点击率涨幅 -- > CVR涨幅
     */
    @ExcelReportIncrease(belongField = "validClickRateShow")
    @Excel(name = "CVR涨幅")
    private String validClickRateChange;
    /**
     * 转化率 -- > 点击率
     */
    @Excel(name = "点击率")
    private String conversionShow;
    private Double conversion;

    /**
     * 转化率涨幅 -- > 点击率涨幅
     */
    @ExcelReportIncrease(belongField = "conversionShow")
    @Excel(name = "点击率涨幅")
    private String conversionChange;


    /**
     * 发券占比
     */
    @Excel(name = "发券占比")
    private String openPvRateShow;
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    @ExcelReportIncrease(belongField = "openPvRateShow")
    @Excel(name = "发券占比涨幅")
    private String openPvRateChange;

    /**
     * 券收入
     */
    @Excel(name = "券收入",type = 10)
    private Double income;
    /**
     * 券收入涨幅
     */
    @ExcelReportIncrease(belongField = "income")
    @Excel(name = "券收入涨幅")
    private String incomeChange;

    /**
     * 发券aurp
     */
    @Excel(name = "发券ARPU",type = 10)
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    @ExcelReportIncrease(belongField = "openPvAurp")
    @Excel(name = "发券ARPU涨幅")
    private String openPvAurpChange;

    /**
     * 点击aurp -- > 点击均价
     */
    @Excel(name = "点击均价",type = 10)
    private Double clickAurp;
    /**
     * 点击aurp涨幅 -- > 点击均价涨幅
     */
    @ExcelReportIncrease(belongField = "clickAurp")
    @Excel(name = "点击均价涨幅")
    private String clickAurpChange;

    /**
     * 券消耗
     */
    @Excel(name = "券消耗",type = 10)
    private  Double consume;

    /**
     * 券消耗涨幅
     */
    @ExcelReportIncrease(belongField = "consume")
    @Excel(name = "券消耗涨幅")
    private  String consumeChange;

    /**
     * 曝光成功率 -- > 落地页到达率
     */
    @Excel(name = "落地页到达率")
    private String  exposureRateShow;
    private  Double exposureRate;

    public String getExposureRateShow() {
        return exposureRateShow;
    }

    public void setExposureRateShow(String exposureRateShow) {
        this.exposureRateShow = exposureRateShow;
    }

    /**
     * 曝光成功率涨幅 -- > 落地页到达率涨幅
     */
    @ExcelReportIncrease(belongField = "exposureRateShow")
    @Excel(name = "落地页到达率涨幅")
    private  String exposureRateChange;

    public Double getConsume() {
        return consume;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public String getConsumeChange() {
        return consumeChange;
    }

    public void setConsumeChange(String consumeChange) {
        this.consumeChange = consumeChange;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateChange() {
        return exposureRateChange;
    }

    public void setExposureRateChange(String exposureRateChange) {
        this.exposureRateChange = exposureRateChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getBusinessNumber() {
        return businessNumber;
    }

    public void setBusinessNumber(String businessNumber) {
        this.businessNumber = businessNumber;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public String getValidClickChange() {
        return validClickChange;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public Double getConversion() {
        return conversion;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public String getConversionChange() {
        return conversionChange;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public String getOpenPvRateChange() {
        return openPvRateChange;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public String getClickAurpChange() {
        return clickAurpChange;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public String getConversionShow() {
        return conversionShow;
    }

    public void setConversionShow(String conversionShow) {
        this.conversionShow = conversionShow;
    }

    public String getOpenPvRateShow() {
        return openPvRateShow;
    }

    public void setOpenPvRateShow(String openPvRateShow) {
        this.openPvRateShow = openPvRateShow;
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public String getValidClickRateShow() {
        return validClickRateShow;
    }

    public void setValidClickRateShow(String validClickRateShow) {
        this.validClickRateShow = validClickRateShow;
    }

    public String getValidClickRateChange() {
        return validClickRateChange;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    @Override
    public String[] getDefaultExportFields() {
        return new String[]{"number","appKey","appName","businessNumber"};
    }
}
