package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.integration.utils.DataParkUtils;
import com.bxm.adsmanager.model.annotation.ExcelReportIncrease;
import com.bxm.adsmanager.model.base.BaseExportVo;
import com.bxm.commons.currency.Money;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/26 10:16
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
public class TicketCountCommonExportVo extends BaseExportVo implements Serializable {

    private static final long serialVersionUID = 3323004177068678838L;


    /**
     * 编号
     */
    @Excel(name = "编号")
    private String number;

    /**
     * 时间段
     */
    @Excel(name = "时间段")
    private Integer hours;

    /**
     * 日期
     */

    private String datetime;


    /**
     * 券id
     */
    private Long certificateid;

    /**
     * appkey
     */

    private String appkey;

    /**
     * 子渠道标志
     */

    private String business;

    /**
     * 发券请求
     */

    private Integer sendPv;
    /**
     * 发券请求涨幅
     */

    private String sendPvChange;
    /**
     * 点击量
     */
    @Excel(name = "点击量")
    private Integer clickPv;
    /**
     * 点击量涨幅
     */

    @ExcelReportIncrease(belongField = "clickPv")
    @Excel(name = "点击量涨幅")
    private String clickPvChange;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量")
    private Integer openPv;
    /**
     * 曝光量（发券量）涨幅
     */
    @ExcelReportIncrease(belongField = "openPv")
    @Excel(name = "发券量涨幅")
    private String openPvChange;

    /**
     * 有效点击量
     */
    @Excel(name = "有效点击量")
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    @ExcelReportIncrease(belongField = "validClick")
    @Excel(name = "有效点击量涨幅")
    private String validClickChange;


    /**
     * 有效点击率 -- > CVR
     */
    private Double validClickRate;
    @Excel(name = "CVR")
    private String validClickRateShow;


    /**
     * 有效点击率涨幅 -- > CVR涨幅
     */
    @ExcelReportIncrease(belongField = "validClickRate")
    @Excel(name = "CVR涨幅")
    private String validClickRateChange;

    /**
     * 转化率 -- > 点击率
     */
    private Double conversion;
    @Excel(name = "点击率")
    private String conversionShow;

    /**
     * 转化率涨幅 -- > 点击率涨幅
     */
    @ExcelReportIncrease(belongField = "conversion")
    @Excel(name = "点击率涨幅")
    private String conversionChange;

    /**
     * 券收入
     */
    private Double income;
    /**
     * 券收入涨幅
     */
    private String incomeChange;


    /**
     * 发券aurp
     */
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    private String openPvAurpChange;
    /**
     * 点击aurp
     */
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    private String clickAurpChange;

    /**
     * 有效点击率占比
     */
    private Double qualityFactor;

    private String qualityFactorShow;

    /**
     * 有效点击率占比涨幅
     */
    private String qualityFactorChange;

    /**
     * 发券占比
     */
    @Excel(name = "发券占比")
    private String openPvRateShow;
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    @ExcelReportIncrease(belongField = "openPvRateShow")
    @Excel(name = "发券占比涨幅")
    private String openPvRateChange;

    private String positionId;
    /**
     * 券消耗
     */
    @Excel(name = "券消耗")
    private  Double consume;

    /**
     * 券消耗涨幅
     */
    @ExcelReportIncrease(belongField = "consume")
    @Excel(name = "券消耗涨幅")
    private  String consumeChange;

    /**
     * 曝光成功率 -- > 落地页到达率
     */
    private  Double exposureRate;
    @Excel(name = "落地页到达率")
    private  String exposureRateShow;

    /**
     * 曝光成功率涨幅 -- > 落地页到达率涨幅
     */
    @ExcelReportIncrease(belongField = "exposureRate")
    @Excel(name = "落地页到达率涨幅")
    private  String exposureRateChange;

    /**
     * 礼券日平均权重
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private BigDecimal averageWeightByDay;

    /**
     * 礼券发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String sendTicketProbability;

    /**
     * 礼券发券的设备限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String equipmentConstraints;

    /**
     * 礼券发券的环境限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String environmentConstraints;

    /**
     * 礼券发券的地域限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String regionConstraints;

    /**
     * 礼券的总发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    private String totalSendTicketProbability;

    /**
     * 发券时间
     * add by kk,xie times:2018-7-4 11:50:03
     */
    private String sendTicketTime;

    public BigDecimal getAverageWeightByDay() {
        return averageWeightByDay;
    }

    public void setAverageWeightByDay(BigDecimal averageWeightByDay) {
        this.averageWeightByDay = averageWeightByDay;
    }

    public String getSendTicketProbability() {
        return sendTicketProbability;
    }

    public void setSendTicketProbability(String sendTicketProbability) {
        this.sendTicketProbability = sendTicketProbability;
    }

    public String getEquipmentConstraints() {
        return equipmentConstraints;
    }

    public void setEquipmentConstraints(String equipmentConstraints) {
        this.equipmentConstraints = equipmentConstraints;
    }

    public String getEnvironmentConstraints() {
        return environmentConstraints;
    }

    public void setEnvironmentConstraints(String environmentConstraints) {
        this.environmentConstraints = environmentConstraints;
    }

    public String getRegionConstraints() {
        return regionConstraints;
    }

    public void setRegionConstraints(String regionConstraints) {
        this.regionConstraints = regionConstraints;
    }

    public String getTotalSendTicketProbability() {
        return totalSendTicketProbability;
    }

    public void setTotalSendTicketProbability(String totalSendTicketProbability) {
        this.totalSendTicketProbability = totalSendTicketProbability;
    }

    public String getSendTicketTime() {
        return sendTicketTime;
    }

    public void setSendTicketTime(String sendTicketTime) {
        this.sendTicketTime = sendTicketTime;
    }

    public String getExposureRateShow() {
        return DataParkUtils.getPercent(exposureRate);
    }

    public void setExposureRateShow(String exposureRateShow) {
        this.exposureRateShow = exposureRateShow;
    }

    public Double getConsume() {
        return consume!=null?(double)Math.round(consume/10)/100:0;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public String getConsumeChange() {
        return consumeChange;
    }

    public void setConsumeChange(String consumeChange) {
        this.consumeChange = consumeChange;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateChange() {
        return exposureRateChange;
    }

    public void setExposureRateChange(String exposureRateChange) {
        this.exposureRateChange = exposureRateChange;
    }

    public String getPositionId() {
        if (StringUtils.isNotEmpty(business)) {
            positionId = appkey + "-" + business.replace("ad-", "");
        }
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return sendPvChange;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public String getValidClickChange() {
        return validClickChange;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public String getValidClickRateChange() {
        return validClickRateChange;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public Double getConversion() {
        return conversion;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public String getConversionChange() {
        return conversionChange;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public Double getIncome() {
        return income;
    }

    public long getIncomeLi() {
        if(null == income){
            return 0;
        }
        Money money = Money.ofYuan(income);
        return money.getLi();
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public String getClickAurpChange() {
        return clickAurpChange;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public String getQualityFactorChange() {
        return qualityFactorChange;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public String getOpenPvRateChange() {
        return openPvRateChange;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getValidClickRateShow() {
        return DataParkUtils.getPercent(validClickRate);
    }

    public void setValidClickRateShow(String validClickRateShow) {
        this.validClickRateShow = validClickRateShow;
    }

    public String getConversionShow() {
        return DataParkUtils.getPercent(conversion);
    }

    public void setConversionShow(String conversionShow) {
        this.conversionShow = conversionShow;
    }

    public String getOpenPvRateShow() {
        return DataParkUtils.getPercent(openPvRate);
    }

    public void setOpenPvRateShow(String openPvRateShow) {
        this.openPvRateShow = openPvRateShow;
    }

    public String getQualityFactorShow() {
        return DataParkUtils.getQualityFactorShow(qualityFactor);
    }

    /*public String getQualityFactorShow() {
        return qualityFactor+"";
    }*/

    public void setQualityFactorShow(String qualityFactorShow) {
        this.qualityFactorShow = qualityFactorShow;
    }

    @Override
    public String[] getDefaultExportFields() {
        return new String[]{"number","hours"};
    }
}
