package com.bxm.adsmanager.model.vo.report;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.model.annotation.ExcelReportIncrease;
import com.bxm.adsmanager.model.base.BaseExportVo;

/**
 * @author ganquan
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.vo.report.TicketCountVo.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-02 19:05:00
 * @modifier ganquan
 * @updated 2018-03-02 19:05:00
 */
public class TicketCountVo extends BaseExportVo {

    /**
     * 编号
     */
    private String number;

    /**
     * 券id
     */
    @Excel(name = "券id")
    private Long certificateid;

    /**
     * 券名称
     */
    @Excel(name = "券名称")
    private String certificateName;

    /**
     * 广告主名称
     */
    @Excel(name = "广告主名称")
    private String advertiserName;

    /**
     * AE
     */
    @Excel(name = "AE")
    private String AEName;

    /**
     * 一级标签名称
     */
    @Excel(name = "广告类别")
    private String tagName;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量", type = 10 )
    private Integer openPv;
    /**
     * 曝光量（发券量）涨幅
     */
    @ExcelReportIncrease(belongField = "openPv")
    @Excel(name = "发券量涨幅")
    private String openPvChange;

    @Excel(name = "点击量", type = 10 )
    private Integer clickPv;

    /**
     * 点击量涨幅
     */
    @ExcelReportIncrease(belongField = "clickPv")
    @Excel(name = "点击量涨幅")
    private String clickPvChange;

    /**
     * 有效点击量
     */
    @Excel(name = "有效点击量", type = 10 )
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    @ExcelReportIncrease(belongField = "validClick")
    @Excel(name = "有效点击量涨幅")
    private String validClickChange;

    /**
     * 有效点击率 -- > CVR
     */
    @Excel(name = "CVR")
    private String validClickRateShow;
    private Double validClickRate;

    /**
     * 有效点击率涨幅 -- > CVR涨幅
     */
    @Excel(name = "有效点击率涨幅")
    private String validClickRateChange;

    /**
     * 转化率
     */
    @Excel(name = "转化率")
    private String conversionShow;
    private Double conversion;

    /**
     * 转化率涨幅
     */
    @Excel(name = "转化率涨幅")
    private String conversionChange;

    /**
     * 有效点击率占比 -- > CVR占比
     */
    @Excel(name = "CVR占比")
    private String qualityFactorShow;
    private Double qualityFactor;

    /**
     * 有效点击率占比涨幅 -- > CVR占比涨幅
     */
    @ExcelReportIncrease(belongField = "qualityFactorShow")
    @Excel(name = "CVR占比涨幅")
    private String qualityFactorChange;

    /**
     * 发券占比
     */
    @Excel(name = "发券占比")
    private String openPvRateShow;
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    @ExcelReportIncrease(belongField = "openPvRateShow")
    @Excel(name = "发券占比涨幅")
    private String openPvRateChange;

    /**
     * 券收入
     */
    @Excel(name = "券收入", type = 10 )
    private Double income;
    /**
     * 券收入涨幅
     */
    @ExcelReportIncrease(belongField = "income")
    @Excel(name = "券收入涨幅")
    private String incomeChange;

    /**
     * 发券aurp
     */
    @Excel(name = "发券ARPU", type = 10 )
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    @Excel(name = "发券ARPU涨幅")
    private String openPvAurpChange;

    /**
     * 点击aurp
     */
    @Excel(name = "点击ARPU")
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    @Excel(name = "点击ARPU涨幅")
    private String clickAurpChange;
    /**
     * 券消耗
     */
    @Excel(name = "券消耗")
    private  Double consume;

    /**
     * 券消耗涨幅
     */
    @ExcelReportIncrease(belongField = "consume")
    @Excel(name = "券消耗涨幅")
    private  String consumeChange;

    /**
     * 曝光成功率 -- > 落地页到达率
     */
    @Excel(name = "落地页到达率")
    private String  exposureRateShow;
    private  Double exposureRate;

    public String getExposureRateShow() {
        return exposureRateShow;
    }

    public void setExposureRateShow(String exposureRateShow) {
        this.exposureRateShow = exposureRateShow;
    }

    /**
     * 曝光成功率涨幅 -- > 落地页到达率涨幅
     */
    @ExcelReportIncrease(belongField = "exposureRateShow")
    @Excel(name = "落地页到达率涨幅")
    private  String exposureRateChange;

    public Double getConsume() {
        return consume;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public String getConsumeChange() {
        return consumeChange;
    }

    public void setConsumeChange(String consumeChange) {
        this.consumeChange = consumeChange;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateChange() {
        return exposureRateChange;
    }

    public void setExposureRateChange(String exposureRateChange) {
        this.exposureRateChange = exposureRateChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getAdvertiserName() {
        return advertiserName;
    }

    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    public String getAEName() {
        return AEName;
    }

    public void setAEName(String AEName) {
        this.AEName = AEName;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return openPvChange;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return clickPvChange;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public String getValidClickChange() {
        return validClickChange;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public String getValidClickRateChange() {
        return validClickRateChange;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public Double getConversion() {
        return conversion;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public String getConversionChange() {
        return conversionChange;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public String getQualityFactorChange() {
        return qualityFactorChange;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public String getOpenPvRateChange() {
        return openPvRateChange;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getIncomeChange() {
        return incomeChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return openPvAurpChange;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public String getClickAurpChange() {
        return clickAurpChange;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public String getValidClickRateShow() {
        return validClickRateShow;
    }

    public void setValidClickRateShow(String validClickRateShow) {
        this.validClickRateShow = validClickRateShow;
    }

    public String getConversionShow() {
        return conversionShow;
    }

    public void setConversionShow(String conversionShow) {
        this.conversionShow = conversionShow;
    }

    public String getQualityFactorShow() {
        return qualityFactorShow;
    }

    public void setQualityFactorShow(String qualityFactorShow) {
        this.qualityFactorShow = qualityFactorShow;
    }

    public String getOpenPvRateShow() {
        return openPvRateShow;
    }

    public void setOpenPvRateShow(String openPvRateShow) {
        this.openPvRateShow = openPvRateShow;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String[] getDefaultExportFields() {
        return new String[]{"certificateid","certificateName","advertiserName","AEName","tagName"};
    }
}
