package com.bxm.adsmanager.monitor.controller.timer;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.tbltag.ext.TblAdPostionTagMapperExt;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.constant.IntegrationConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.monitor.AdPositionTagToday;
import com.bxm.adsmanager.model.dao.monitor.AdPositionTicketTagToday;
import com.bxm.adsmanager.model.dto.monitor.AdPositionTicketTagTodayDto;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.monitor.AdPositionTicketService;
import com.bxm.adsmanager.utils.DoubleUtil;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * @author sunzs
 * created on 2019/1/8
 */
@Component
@EnableScheduling
@Slf4j
public class PositionTicketWarnTimer {
    //eg1: cvr异常报警:网赚.加粉类/广告券11645 天祝加粉-点点在广告位003421-3内cvr高达28%，且当前有效点击数据58%存在异常，请时刻关注该广告位；
    //eg2: 有效点击异常率报警：网赚.加粉类/广告券11645 天祝加粉-点点在广告位003421-3内有效点击异常率高达28%，当前cvr为27%，请时刻关注该广告位；
    //@Value("${positionTicketWarn.dingUrl}")
    //https://oapi.dingtalk.com/robot/send?access_token=109c9b297c1124ba420d95e76071491c82287801493f11ab42fdf72a76685fdf
    //private  String positionTicketWarnDingUrl="https://oapi.dingtalk.com/robot/send?access_token=109c9b297c1124ba420d95e76071491c82287801493f11ab42fdf72a76685fdf";

    private final static LinkedBlockingQueue<Message> QUEUE = new LinkedBlockingQueue<>();
    @Autowired
    private MessageSender messageSender;
    private final static String PERCENT = "%";

    private final static Integer ZERO = 0;

    private final static Integer ONE = 1;
    private final static long SLEEP_TIME = 3100;

    @Autowired
    private TblAdPostionTagMapperExt tblAdPostionTagMapperExt;

    @Autowired
    private AdTicketMapper adTicketMapper;

    @Autowired
    private AdPositionTicketService adPositionTicketService;

    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    //10分钟执行一次(重复发送已经报过警的广告位报警信息)
    //@Scheduled(cron = "0 0/10 * * * ?") //十分钟
    public void positionTicketWarn(){
        log.info("positionTicketWarn start");
        long startTime = System.currentTimeMillis();
        try {
            //1.cvr报警
            //先找广告分类在广告位上开启报警的cvr数据.
            List<String> contentList =  Lists.newArrayList();
            cvrWarn(ZERO,contentList);
            //2.有效点击异常率报警
            validWarn(ZERO,contentList);
            /*log.info("1contentList.size()"+JSON.toJSONString(contentList));
            if (CollectionUtils.isNotEmpty(contentList)&&contentList.size()>20){
                *//*String[] strings = new String[contentList.size()];
                contentList.toArray(strings);*//*
                //大于二十条拼接发  num = 每条要拼接多少个
                int num = (int) Math.ceil((double) contentList.size()/(double) 20);
                for (int i =0;i<contentList.size();i++){
                    contents=contents+contentList.get(i);
                    //如果是num的倍数就加入信息
                    if (i/num == 0){
                        messages.add(contents);
                        contents="";
                    }
                }
            }else {
                messages.addAll(contentList);

            }
            if (CollectionUtils.isNotEmpty(messages)){
                for (int i = 0;i<messages.size();i++){
                    messageSend(messages.get(i));
                    log.info("messages0*****"+messages.get(i));
                }
            }*/
        }catch (Exception e){
            log.error("10分钟定时器报警数据查询失败" + e.getMessage(), e);
        }
        log.info("positionTicketWarn end ,用时:{} ",System.currentTimeMillis()-startTime);
    }
    //五分钟执行一次(当实时计算)
    //@Scheduled(cron = "0 0 * * * ?")
    @Async
    public void rePositionTicketWarn(){
        log.info("rePositionTicketWarn start");
        long startTime = System.currentTimeMillis();
        try {
            //1.cvr报警
            //先找广告分类在广告位上开启报警的cvr数据.
            List<String> contentList =  Lists.newArrayList();
            String contents ="";
            cvrWarn(ONE,contentList);
            List<String> messages =  Lists.newArrayList();
            //2.有效点击异常率报警
            validWarn(ONE,contentList);
        }catch (Exception e){
            log.error("1小时定时器报警数据查询失败" + e.getMessage(), e);
        }
        log.info("rePositionTicketWarn end ,用时:{} ",System.currentTimeMillis()-startTime);
    }

    //每天凌晨清除position_ticket异常数据表中的数据
    //@Scheduled(cron = "0 0 0 * * ?")
    public void deletePositionTicketDate(){
        try {
          int result =  adPositionTicketService.deletePositionData();
          log.info("****表清空执行完毕，已删除"+result+"条");
        }catch (Exception e){
            log.error("0点清空表 rpt_ad_position_tag_today 失败 " + e.getMessage(), e);
        }
    }

    private void cvrWarn(Integer isSend,List<String> contentList) throws Exception{
        AdPositionTagToday adPositionTagToday = new AdPositionTagToday();
        adPositionTagToday.setStatus(ZERO);
        adPositionTagToday.setCvrType(ONE);
        adPositionTagToday.setIsSend(isSend);
        List<AdPositionTagToday> adPositionTagTodays = adPositionTicketService.findPositionDateByParam(adPositionTagToday);
        if (CollectionUtils.isNotEmpty(adPositionTagTodays)) {
            Map<String, String> positionNameMap = getPositionDtoMap(adPositionTagTodays,null);
            Map<String, String> mapTag = getTagName();
            List<Integer> positionWarnIds = Lists.newArrayList();
            int count = 0;
            for (AdPositionTagToday positionTagToday : adPositionTagTodays) {
              String content =   sendDingPositionCvr(positionTagToday,positionNameMap,mapTag,isSend);
              if (count!= 0&& 0==count%20){
                Thread.sleep(1000*60);
              }
                ++count;
              contentList.add(content);
              positionWarnIds.add(positionTagToday.getId());
            }
            //将报过警的广告位更新为已发送
            if (CollectionUtils.isNotEmpty(positionWarnIds)&&isSend.intValue()==ZERO) {
              adPositionTicketService.updatePositionSendStatus(positionWarnIds);
            }
        }
            AdPositionTicketTagTodayDto adPositionTicketTagTodayDto = new AdPositionTicketTagTodayDto();
            if (CollectionUtils.isNotEmpty(adPositionTagTodays)){
                //在明细表中这些广告位不报(广告位)
                List<String> positionIds = Lists.newArrayList();
                List<String> tags = Lists.newArrayList();
                for (AdPositionTagToday adPositionTagToday1:adPositionTagTodays){
                    positionIds.add(adPositionTagToday1.getPositionId());
                    tags.add(adPositionTagToday1.getTicketTag());
                }
                adPositionTicketTagTodayDto.setPositionIds(positionIds);
                adPositionTicketTagTodayDto.setTags(tags);
                //需要将明细表中的广告位标示为已发送
                if (CollectionUtils.isNotEmpty(positionIds)){
                    adPositionTicketService.setResend(positionIds);
                }
            }

            adPositionTicketTagTodayDto.setIsSend(isSend);
            List<AdPositionTicketTagToday> adPositionTicketTagTodayList =  adPositionTicketService.findPositionTicketDate(adPositionTicketTagTodayDto);
            if (CollectionUtils.isNotEmpty(adPositionTicketTagTodayList)){
                Map<String,String> positionNameMap2 =getPositionDtoMap(null,adPositionTicketTagTodayList);
                List<String> positionIds = Lists.newArrayList();
                int count = 0;
                for (AdPositionTicketTagToday adPositionTicketTagToday: adPositionTicketTagTodayList){
                    String content = sendDingPositionTicketCvr(adPositionTicketTagToday,positionNameMap2,isSend);
                    if (count!= 0&& 0==count%20){
                        Thread.sleep(1000*60);
                    }
                    ++count;
                    positionIds.add(adPositionTicketTagToday.getPositionId());
                    contentList.add(content);
                }
                //需要将已发送的广告位标示一下
                if (CollectionUtils.isNotEmpty(positionIds)&&isSend==ZERO){
                    adPositionTicketService.setResend(positionIds);
                }
            }
    }

    private void validWarn(Integer isSend,List<String> contentList)throws Exception{
        AdPositionTagToday adPositionTagToday = new AdPositionTagToday();
        adPositionTagToday.setStatus(ZERO);
        adPositionTagToday.setValidClickErrorType(ONE);
        adPositionTagToday.setIsSend(isSend);
        List<AdPositionTagToday> adPositionTagTodays = adPositionTicketService.findPositionDateByParam(adPositionTagToday);
        if (CollectionUtils.isNotEmpty(adPositionTagTodays)) {
            Map<String, String> positionNameMap = getPositionDtoMap(adPositionTagTodays,null);
            Map<String, String> mapTag = getTagName();
            List<Integer> positionWarnIds = Lists.newArrayList();
            int count = 0;
            for (AdPositionTagToday positionTagToday : adPositionTagTodays) {
                String content = sendDingPositionValid(positionTagToday,positionNameMap,mapTag,isSend);
                if (count!= 0&& 0==count%20){
                    Thread.sleep(1000*60);
                }
                ++count;
                contentList.add(content);
                positionWarnIds.add(positionTagToday.getId());
            }
            //将报过警的广告位更新为已发送
            if (CollectionUtils.isNotEmpty(positionWarnIds)&&isSend==ZERO) {
                adPositionTicketService.updatePositionSendStatus(positionWarnIds);
            }
        }
        AdPositionTicketTagTodayDto adPositionTicketTagTodayDto = new AdPositionTicketTagTodayDto();
        if (CollectionUtils.isNotEmpty(adPositionTagTodays)){
            //在明细表中这些广告位不报(广告位+分类)
            List<String> positionIds = Lists.newArrayList();
            List<String> tags = Lists.newArrayList();
            for (AdPositionTagToday adPositionTagToday1:adPositionTagTodays){
                positionIds.add(adPositionTagToday1.getPositionId());
                tags.add(adPositionTagToday1.getTicketTag());
            }
            adPositionTicketTagTodayDto.setPositionIds(positionIds);
            adPositionTicketTagTodayDto.setTags(tags);
            //需要将明细表中的广告位标示为已发送
            if (CollectionUtils.isNotEmpty(positionIds)){
                adPositionTicketService.setResend(positionIds);
            }
        }

        adPositionTicketTagTodayDto.setIsSend(isSend);
        adPositionTicketTagTodayDto.setValidClickErrorType(ONE);
        List<AdPositionTicketTagToday> adPositionTicketTagTodayList =  adPositionTicketService.findPositionTicketDate(adPositionTicketTagTodayDto);
        Map<String,String> positionNameMap2 =getPositionDtoMap(null,adPositionTicketTagTodayList);
        List<String> positionIds = Lists.newArrayList();
        int count = 0;
        for (AdPositionTicketTagToday adPositionTicketTagToday: adPositionTicketTagTodayList){
            String content = sendDingPositionTicketValid(adPositionTicketTagToday,positionNameMap2,isSend);
            if (count!= 0&& 0==count%20){
                Thread.sleep(1000*60);
            }
            ++count;
            contentList.add(content);
            positionIds.add(adPositionTicketTagToday.getPositionId());
        }
        //需要将已发送的广告位标示一下
        if (CollectionUtils.isNotEmpty(positionIds)&&isSend==ZERO){
            adPositionTicketService.setResend(positionIds);
        }

    }


    private Map<String,String> getTagName(){
        //查询标签（券分类）翻译
        List<TblAdTagVo> tablAdTag = tblAdPostionTagMapperExt.findAll();
        Map<String, String> mapTag = new HashMap<>(tablAdTag == null ? 0 : tablAdTag.size());
        // 空判断，防止空指针
        if (CollectionUtils.isNotEmpty(tablAdTag)) {
            tablAdTag.forEach(label -> mapTag.put(label.getCode() + "", label.getFullNameStr()));
        }
        return mapTag;
    }

    private Map<String, String> getPositionDtoMap(List<AdPositionTagToday> list1, List<AdPositionTicketTagToday> list2) {
        List<String> positionIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list1) && CollectionUtils.isEmpty(list2)) {
            list1.forEach(adPositionTagToday -> {
                positionIdList.add(adPositionTagToday.getPositionId());
            });
        } else if (CollectionUtils.isEmpty(list1) && CollectionUtils.isNotEmpty(list2)) {
            list2.forEach(adPositionTicketTagToday -> {
                positionIdList.add(adPositionTicketTagToday.getPositionId());
            });
        }
        //返回广告位的信息<广告位,代号>
        List<AppEntranceAdRO> appEntranceAdROS = newAppEntranceFacadeIntegration.findListByPositionIds(positionIdList);
        Map<String, String> map = Maps.newHashMapWithExpectedSize(appEntranceAdROS.size());
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            map.put(String.format(IntegrationConstant.CODE_NAME_FORMAT, appEntranceAdRO.getCode()) + "-" + appEntranceAdRO.getAppEntranceId(), appEntranceAdRO.getPositionId());
        }
        return map;
    }


    private String sendDingPositionCvr(AdPositionTagToday positionTagToday,Map<String, String> positionNameMap,Map<String, String> mapTag,Integer isSend){
        String tagName = mapTag.get(positionTagToday.getTicketTag());
        String positionName = positionNameMap.get(positionTagToday.getPositionId());
        String cvr = DoubleUtil.savePoint(positionTagToday.getCvr() * 100, 2) + PERCENT;
        String validErrorRate = DoubleUtil.savePoint(positionTagToday.getValidErrorClickPvRate() * 100, 2) + PERCENT;
        String content = "cvr异常报警:" + tagName + "在广告位" + positionName + "内cvr高达" + cvr + ",且当前有效点击数据" + validErrorRate + "存在异常，请时刻关注该广告位；";
        if (isSend==1){
            content="重复:"+content;
        }
        addQueue(content);
        return content;
    }

    private String sendDingPositionTicketCvr(AdPositionTicketTagToday adPositionTicketTagToday,Map<String, String> positionNameMap,Integer isSend){
        Integer ticketId = adPositionTicketTagToday.getTicketId();
        AdTicket adTicket = adTicketMapper.selectByPrimaryKey(ticketId.longValue());
        String ticketName = "";
        if (adTicket!=null){
            ticketName = adTicket.getName();
        }
        String positionName = positionNameMap.get(adPositionTicketTagToday.getPositionId());
        String cvr = DoubleUtil.savePoint(adPositionTicketTagToday.getCvr()*100,2)+PERCENT;
        String validErrorRate = DoubleUtil.savePoint(adPositionTicketTagToday.getValidErrorClickPvRate()*100,2)+PERCENT;
        String content = "cvr异常报警:广告券"+ticketId+ticketName+"在广告位"+positionName+"内cvr高达"+cvr+",且当前有效点击数据"+validErrorRate+"存在异常，请时刻关注该广告位；";
        if (isSend==1){
            content="重复:"+content;
        }
        addQueue(content);
        return content;
    }

    private String  sendDingPositionValid(AdPositionTagToday positionTagToday,Map<String, String> positionNameMap,Map<String, String> mapTag,Integer isSend){
        String tagName = mapTag.get(positionTagToday.getTicketTag());
        String positionName = positionNameMap.get(positionTagToday.getPositionId());
        String cvr = DoubleUtil.savePoint(positionTagToday.getCvr() * 100, 2) + PERCENT;
        String validErrorRate = DoubleUtil.savePoint(positionTagToday.getValidErrorClickPvRate() * 100, 2) + PERCENT;
        String content = "有效点击异常率报警:" + tagName + "在广告位" + positionName + "内有效点击异常率高达" + validErrorRate + ",当前cvr" + cvr + "存在异常，请时刻关注该广告位；";
        if (isSend==1){
            content="重复:"+content;
        }
        addQueue(content);
        return content;
    }

    private String sendDingPositionTicketValid(AdPositionTicketTagToday adPositionTicketTagToday,Map<String, String> positionNameMap,Integer isSend){
        Integer ticketId = adPositionTicketTagToday.getTicketId();
        AdTicket adTicket = adTicketMapper.selectByPrimaryKey(ticketId.longValue());
        String ticketName = "";
        if (adTicket!=null){
            ticketName = adTicket.getName();
        }
        String positionName = positionNameMap.get(adPositionTicketTagToday.getPositionId());
        String cvr = DoubleUtil.savePoint(adPositionTicketTagToday.getCvr()*100,2)+PERCENT;
        String validErrorRate = DoubleUtil.savePoint(adPositionTicketTagToday.getValidErrorClickPvRate()*100,2)+PERCENT;
        String content = "有效点击异常率报警:广告券" + ticketId+ticketName + "在广告位" + positionName + "内有效点击异常率高达" + validErrorRate + ",当前cvr为"+cvr + "存在异常，请时刻关注该广告位；";
        if (isSend==1){
            content="重复:"+content;
        }
        addQueue(content);
        return content;
    }

    public void  addQueue(String content) {
        try {
            Message message = new Message();
            message.setContent(content);
            message.setTos(null);
            if (!QUEUE.add(message)){
                log.warn("Add queue is error , content is {}",content);
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
    }

    @Async
    public void messageSend() {
        try {
            log.info("Send DingDing message is start ,QUEUE size {}",QUEUE.size());
            while(!QUEUE.isEmpty()){
                messageSender.send2(QUEUE.take());
                //钉钉一分钟只支持发送20条消息
                Thread.sleep(SLEEP_TIME);
            }
            log.info("Send DingDing message is end ,QUEUE size {}",QUEUE.size());
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
    }

}
