package com.bxm.adsmanager.monitor.controller.timer;

import java.text.MessageFormat;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import com.bxm.adsmanager.model.constant.WarnConfigTemplateConstant;
import com.bxm.adsmanager.model.dto.monitor.TicketUrlDto;
import com.bxm.adsmanager.model.enums.WarnConfigEnum;
import com.bxm.adsmanager.model.vo.monitor.TicketUrlVo;
import com.bxm.adsmanager.service.monitor.TicketWarnConfigService;
import com.bxm.adsmanager.utils.DingtalkMsgUtil;

@Component
@EnableScheduling
public class TicketTimer {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketTimer.class);

    /**
     * 广告券预警配置接口
     */
    @Autowired
    private TicketWarnConfigService ticketWarnConfigService;

    @Autowired
    private Environment environment;

    //发送广告券落地页达到率报警数据
    //@Scheduled(cron = "0 0/30 * * * ?")
    public void sendTicketUrlWarnInfoJob() {
        //获取激活环境
        String[] env = environment.getActiveProfiles();
        Boolean envFlag = null;
        if (ArrayUtils.isNotEmpty(env)) {
            envFlag = false;
            if (ArrayUtils.contains(env, "dev") || ArrayUtils.contains(env, "test")) {
                envFlag = true;
            }
        }
        TicketUrlDto param = new TicketUrlDto();
        List<TicketUrlVo> list = null;
        try {
            list = ticketWarnConfigService.getTicketUrlWarnList(param);
            if (!CollectionUtils.isEmpty(list)) {
                //消息模板详细信息
                String desc = "";
                for (TicketUrlVo record : list) {
                    desc += generateTicketUrlWarnTemplate(record) + ";" + "\n";
                }
                if (StringUtils.isNotBlank(desc) && envFlag != null && !envFlag) {
                    DingtalkMsgUtil.sendMsg(
                            "https://oapi.dingtalk.com/robot/send?access_token=224cce0b19c459fdf43cdd04f8fd4b19dbad6edbfdb2908e223aa5bf3c818718",
                            desc, false, null);
                }
                //上线可去掉以下代码
                if (StringUtils.isNotBlank(desc) && envFlag!=null && envFlag){
                    DingtalkMsgUtil.sendMsg(
                            "https://oapi.dingtalk.com/robot/send?access_token=d733229dec9ee619316ce647080defbc29b725a03c1fbe9c19ed0b6628553361",
                            desc, false, null);
                }
            }
        } catch (Exception e) {
            LOGGER.error("发送广告落地页达到率报警信息异常:" + e.getMessage(), e);
        }
    }

    //消息模板封装
    private String generateTicketUrlWarnTemplate(TicketUrlVo record){
        //广告名称
        String param0 = record.getShopsname();
        //广告ID
        String param1 = null;
        if(record.getCertificateId() !=null){
            param1 = String.valueOf(record.getCertificateId());
        }
        //监控项目
        String param2 = WarnConfigEnum.TICKET_URL.getConfigDesc();
        //粒度环境
        String param3 = record.getEnvironment();
        //监控时间范围
        Integer param4 = record.getMonitorPeriod();
        //设置的阈值
        Double param5 = record.getThresholdExposureRateMax();
        //当前值
        Double param6 = record.getExposureRate();
        String templateInfo = MessageFormat.format(WarnConfigTemplateConstant.WARN_INFO_TEMPLATE,param0, param1,param2,param3,param4,param5,param6);
        return templateInfo;
    }
}
