package com.bxm.adsmanager.monitor.controller.warn;

import com.bxm.adsmanager.model.dao.alarm.AlarmPlan;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.ro.AlarmPlanRo;
import com.bxm.adsmanager.monitor.controller.base.BaseController;
import com.bxm.adsmanager.service.alarm.AlarmPlanService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author yirenjie
 * createDate:  2019/3/6
 */
@RestController
@RequestMapping("/alarmPlan")
@Slf4j
public class AlarmPlanController extends BaseController {

    @Resource
    private AlarmPlanService alarmPlanService;

    @RequestMapping("/queryList")
    public ResultModel<PageInfo<AlarmPlan>> queryList(AlarmPlanRo alarmPlanRo) {
        ResultModel<PageInfo<AlarmPlan>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(alarmPlanService.queryList(alarmPlanRo));
        return resultModel;
    }

    @RequestMapping("/add")
    public ResultModel add(HttpServletRequest request, HttpServletResponse response,
                           @RequestBody AlarmPlanRo alarmPlanRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        try {
            resultModel.setSuccessed(alarmPlanService.add(alarmPlanRo, user));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc(e.getMessage());
        }
        return resultModel;
    }

    @RequestMapping("/modify")
    public ResultModel modify(HttpServletRequest request, HttpServletResponse response,
                              @RequestBody AlarmPlanRo alarmPlanRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        resultModel.setSuccessed(alarmPlanService.modify(alarmPlanRo, user));
        return resultModel;
    }

    @RequestMapping("/delete")
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response,
                              AlarmPlanRo alarmPlanRo) {
        ResultModel resultModel = new ResultModel();
        User user = getUser(request, response);
        resultModel.setSuccessed(alarmPlanService.delete(alarmPlanRo, user));
        return resultModel;
    }

}
