package com.bxm.adsmanager.monitor.druid;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.io.IOException;


/**
 * Created by wuwenquan on 2018/12/12.
 */
@Configuration
@MapperScan(basePackages = "com.bxm.adsmanager.dal.mapper", sqlSessionTemplateRef = "datasourceTemplate1")
public class Configuration1 {


    @Bean(name = "datasourceDataSource1")
    @ConfigurationProperties(prefix = "druid")
    @Primary
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name = "datasourceSessionFactory1")
    @Primary
    FactoryBean<SqlSessionFactory> sqlSessionFactory(
            @Qualifier(value = "datasourceDataSource1") DataSource dataSource
    ) throws IOException {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:sql/**/*.xml"));
        return sqlSessionFactoryBean;
    }

    @Bean(name = "datasourceTemplate1")
    @Primary
    SqlSessionTemplate sqlSessionTemplate(
            @Qualifier(value = "datasourceSessionFactory1")
                    SqlSessionFactory sqlSessionFactory
    ) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean(name = "datasourceManager1")
    @Primary
    public DataSourceTransactionManager testTransactionManager(@Qualifier("datasourceDataSource1") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}
