///*
// * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
// * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
// * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
// */
//package com.bxm.adsmanager.monitor.redis;
//
//import com.alibaba.fastjson.JSON;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.beans.factory.annotation.Qualifier;
//import org.springframework.stereotype.Component;
//import redis.clients.jedis.Jedis;
//import redis.clients.jedis.JedisPool;
//import redis.clients.jedis.Pipeline;
//
//import java.util.Map;
//import java.util.Set;
//
///**
// * <h3>Shenjue.java基本描述</h3>
// * <p></p>
// *
// * @author hcmony
// * @since V1.0.0, 2018/03/16 11:46
// */
//@Component
//public class RedisNewClient {
//
//	private static final Logger log = LoggerFactory.getLogger(RedisNewClient.class);
//	
//    @Autowired
//	@Qualifier("redis1PoolFactory")
//	private JedisPool jedisPool;
//
//	public void incrRedis(String key) {
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			jedis.incr(key);
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//	}
//
//	public void incrRedisWhitDB(String key, Integer dbIndex ) {
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (null !=  dbIndex) {
//				jedis.select(dbIndex);
//			}
//			jedis.incr(key);
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//	}
//
//	public String getRedis(String key) {
//		Jedis jedis = null;
//		String result = null;
//		try {
//			jedis = jedisPool.getResource();
//			result = jedis.get(key);
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//		return result;
//	}
//
//	public void set(String key, String value) {
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			jedis.set(key, value);
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//	}
//
//	public void setWithDB(String key, String value, Long seconds, Integer dbIndex) {
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			jedis.set(key, value);
//			if (seconds != null) {
//				jedis.expire(key, seconds.intValue());
//			}
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//	}
//
//	public String getRedisWhitDB(String key, Integer dbIndex) {
//		Jedis jedis = null;
//		String result = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//
//			result = jedis.get(key);
//		} catch (Exception e) {
//			log.error(e.getMessage());
//		} finally {
//			jedis.close();
//		}
//		return result;
//	}
//	
//	public void PfAdd(String key,String value,Integer dbIndex,Long seconds){
//    	Jedis jedis = null;
//        try {
//            jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			jedis.pfadd(key, value);
//			if (seconds != null) {
//				jedis.expire(key, seconds.intValue());
//			}
//        } finally {
//            // 返还到连接池
//            jedis.close();
//        }
//    }
//	
//	public Integer pfCount(String key,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			return (int) jedis.pfcount(key);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	
//	/**
//	 * 将key 添加至redis集合中
//	 * @param key
//	 * @param value
//	 * @param dbIndex
//	 */
//	public void sadd(String key,String value,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			jedis.sadd(key,value);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//
//	/**
//	 * 获取rediskey 中的集合数据
//	 */
//	public Set<String> smembers(String key,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			return jedis.smembers(key);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//
//	/**
//	 * 移除rediskey中的集合数据
//	 */
//	public void srem(String key,String value,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			jedis.srem(key, value);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	/**
//	 * 为黑名单设计的批量新增到 hset
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param map
//	 * @param seconds
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void batchHset(String key, Map<String,Set<Integer>> map, Long seconds, Integer dbIndex) {
//		Jedis jedis = new Jedis();
//		try {
//			jedis = jedisPool.getResource();
//			Pipeline pipeline = jedis.pipelined();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			//获取key
//			int index = 0;
//			for(String mapKey:map.keySet()){
//					if (map.get(mapKey) != null) {
//						pipeline.hset(key, mapKey, JSON.toJSONString(map.get(mapKey)));
//					}
//					//一千条数据以内设置同步
//					if (++index % 1000 == 0) {
//						pipeline.sync();
//					}
//			}
//			pipeline.sync();
//
//			//若是有时间限制
//			if(seconds!=null){
//				pipeline.expire(key.toString(), seconds.intValue());
//
//			}
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	/**
//	 * 为黑名单设计的批量新增到 hset
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param map
//	 * @param seconds
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void batchHsetForAct(String key, Map<String,String> map, Long seconds, Integer dbIndex) {
//		Jedis jedis = new Jedis();
//		try {
//			jedis = jedisPool.getResource();
//			Pipeline pipeline = jedis.pipelined();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			//获取key
//			int index = 0;
//			for(String mapKey:map.keySet()){
//				if (map.get(mapKey) != null) {
//					pipeline.hset(key, mapKey, map.get(mapKey));
//				}
//				//一千条数据以内设置同步
//				if (++index % 1000 == 0) {
//					pipeline.sync();
//				}
//			}
//			pipeline.sync();
//
//			//若是有时间限制
//			if(seconds!=null){
//				pipeline.expire(key.toString(), seconds.intValue());
//
//			}
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	/**
//	 * 为黑名单设计的批量新增到 hset
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param set
//	 * @param seconds
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void batchSAdd(String key, Set<String> set, Long seconds, Integer dbIndex) {
//		Jedis jedis = new Jedis();
//		try {
//			jedis = jedisPool.getResource();
//			Pipeline pipeline = jedis.pipelined();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			//获取key
//			int index = 0;
//			for(String s:set){
//				if(s!=null){
//					pipeline.sadd(key,s);
//				}
//				//一千条数据以内设置同步
//				if (++index % 1000 == 0) {
//					pipeline.sync();
//				}
//			}
//			pipeline.sync();
//
//			//若是有时间限制
//			if(seconds!=null){
//				pipeline.expire(key.toString(), seconds.intValue());
//			}
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//
//
//	/**
//	 * 正真删除 key
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void delKey(String key,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			jedis.del(key);
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//
//
//	public void tenMinKey(String key,Integer dbIndex){
//		expireKey(key,dbIndex,1800);
//	}
//	/**
//	 * key保留时间
//	 * @author 董朱旭
//	 * @time 2017/12/13
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param dbIndex
//	 * @param time
//	 * @return void
//	 */
//	public void expireKey(String key,Integer dbIndex,Integer time){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			//30分钟有效期
//			jedis.expire(key,time);
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	/**
//	 * 删除哈希结构里面的某个域
//	 * @author 董朱旭
//	 * @time 2017/12/13
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param filed
//	 * @param value
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void hset(String key,String filed,String value,Integer dbIndex, Long seconds){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//
//			jedis.hset(key,filed,value);
//			//若是有时间限制
//			if(seconds!=null){
//				jedis.expire(key.toString(), seconds.intValue());
//			}
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	/**
//	 * 删除哈希结构里面的某个域
//	 * @author 董朱旭
//	 * @time 2017/12/13
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param filed
//	 * @param dbIndex
//	 * @return void
//	 */
//	public void hdel(String key,String filed,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			jedis = jedisPool.getResource();
//			//选择数据库
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//
//			jedis.hdel(key,filed);
//		}catch (Exception e){
//			log.error(e.toString());
//		}finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	
//	/**
//	 * 获取哈希里面的内容
//	 * @author 董朱旭
//	 * @time 2017/11/24
//	 * @CopyRight 杭州微财网络科技有限公司
//	 * @param key
//	 * @param dbIndex
//	 * @return java.lang.String
//	 */
//	public String hGet(String key,String field,Integer dbIndex){
//		Jedis jedis = null;
//		try {
//			 jedis = jedisPool.getResource();
//			if (dbIndex != null) {
//				jedis.select(dbIndex);
//			}
//			return  jedis.hget(key,field);
//		} finally {
//			// 返还到连接池
//			jedis.close();
//		}
//	}
//	
//	 /**
//     * 根据key获取哈希里面的内容
//     * @CopyRight 杭州微财网络科技有限公司
//     * @param key
//     * @param dbIndex
//     * @return Map<String,String>
//     */
//      public Map<String,String> hGetAll(String key,Integer dbIndex){
//        Jedis jedis = null;
//        try {
//             jedis = jedisPool.getResource();
//            if (dbIndex != null) {
//                jedis.select(dbIndex);
//            }
//            return  jedis.hgetAll(key);
//        } finally {
//            // 返还到连接池
//            jedis.close();
//        }
//    }
//}
