/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.abtest;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.abtest.AbTestDictionariesVo;
import com.bxm.adsmanager.service.abtest.AbTestDictionariesService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/abtest"})
public class AbTestDictionariesController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbTestDictionariesController.class);
    @Autowired
    AbTestDictionariesService abTestDictionariesService;

    @RequestMapping(value={"/dictionaries/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="algorithmName") String algorithmName) {
        try {
            User user = this.getUser(request, response);
            this.abTestDictionariesService.add(algorithmName, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u7b97\u6cd5\u5b57\u5178\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/dictionaries/update"}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="algorithmName") String algorithmName, @RequestParam(value="algorithmCode") Integer algorithmCode) {
        try {
            User user = this.getUser(request, response);
            this.abTestDictionariesService.update(algorithmName, algorithmCode, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7b97\u6cd5\u5b57\u5178\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/dictionaries/getPageList"}, produces={"application/json"})
    public ResultModel<PageInfo<AbTestDictionariesVo>> getPageList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="algorithmName", required=false) String algorithmName, @RequestParam(value="algorithmCode", required=false) String algorithmCode) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.abTestDictionariesService.getPageList(algorithmName, algorithmCode, pageNum, pageSize));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7b97\u6cd5\u5b57\u5178\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u7b97\u6cd5\u5b57\u5178\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/dictionaries/getList"}, produces={"application/json"})
    public ResultModel<List<AbTestDictionariesVo>> getList(@RequestParam(value="algorithmName", required=false) String algorithmName, @RequestParam(value="algorithmCode", required=false) String algorithmCode) {
        ResultModel resultModel = new ResultModel();
        try {
            List list = this.abTestDictionariesService.getPageList(algorithmName, algorithmCode, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getList();
            resultModel.setReturnValue((Object)list);
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7b97\u6cd5\u5b57\u5178\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u7b97\u6cd5\u5b57\u5178\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

