/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adapi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adapi.facade.MaterialService;
import com.bxm.adapi.facade.model.ImageDto;
import com.bxm.adapi.facade.model.MaterialDto;
import com.bxm.adapi.facade.model.MaterialEditDto;
import com.bxm.adapi.facade.model.MaterialRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping(value={"/adapi/material"})
@Api(description="\u7d20\u6750\u5e93\u76f8\u5173\u63a5\u53e3")
public class MaterialController {
    @Autowired(required=false)
    private MaterialService materialService;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Boolean> add(@RequestParam(value="name") String name, @RequestParam(value="images", required=false) String images, @RequestParam(value="title", required=false) String title, @RequestParam(value="introduction", required=false) String introduction) throws Exception {
        MaterialEditDto materialEdit = new MaterialEditDto();
        materialEdit.setName(name);
        materialEdit.setTitle(title);
        materialEdit.setIntroduction(introduction);
        if (StringUtils.isNotEmpty((CharSequence)images)) {
            materialEdit.setImages(JSONObject.parseArray((String)images, ImageDto.class));
        }
        return this.materialService.add(materialEdit);
    }

    @RequestMapping(value={"/addBatch"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Boolean> addBatch(MaterialEditDto materialEditDto) throws Exception {
        return this.materialService.addBatch(materialEditDto);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> delete(@RequestParam(value="ids", required=true) List<Long> ids) throws Exception {
        return this.materialService.delete(ids);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> update(@RequestParam(value="id") Long id, @RequestParam(value="name") String name, @RequestParam(value="images", required=false) String images, @RequestParam(value="title", required=false) String title, @RequestParam(value="introduction", required=false) String introduction) throws Exception {
        MaterialEditDto materialEdit = new MaterialEditDto();
        materialEdit.setId(id);
        materialEdit.setName(name);
        materialEdit.setTitle(title);
        materialEdit.setIntroduction(introduction);
        if (StringUtils.isNotEmpty((CharSequence)images)) {
            materialEdit.setImages(JSONObject.parseArray((String)images, ImageDto.class));
        }
        return this.materialService.update(materialEdit);
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<MaterialRo>> getList(MaterialDto MaterialDto2) {
        return this.materialService.getList(MaterialDto2);
    }
}

