/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adapi;

import com.bxm.adapi.facade.MediaAdPositionService;
import com.bxm.adapi.facade.model.MediaAdPositionDto;
import com.bxm.adapi.facade.model.MediaAdPositionRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.media.MediaCommonConfigFacadeIntegration;
import com.bxm.adsmanager.model.enums.MediaConfigEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping(value={"/adapi/mediaAdPosition"})
@Api(description="\u5a92\u4f53\u5e7f\u544a\u4f4d\u76f8\u5173\u63a5\u53e3")
public class MediaAdPositionController {
    private static final Logger log = LoggerFactory.getLogger(MediaAdPositionController.class);
    @Autowired
    private MediaAdPositionService mediaAdPositionService;
    @Autowired
    private MediaCommonConfigFacadeIntegration mediaCommonConfigFacadeIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @RequestMapping(value={"/getList"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(MediaAdPositionDto mediaAdPositionDto) {
        ResultModel resultModel = this.mediaAdPositionService.getList(mediaAdPositionDto);
        if (resultModel != null && resultModel.isSuccessed() && resultModel.getReturnValue() != null && !CollectionUtils.isEmpty((Collection)((PageInfo)resultModel.getReturnValue()).getList())) {
            Map map = this.mediaCommonConfigFacadeIntegration.findMediaConfigIdToNameMap(MediaConfigEnum.POSITION_CLASS.getTypeCode());
            List list = ((PageInfo)resultModel.getReturnValue()).getList();
            list.forEach(mediaAdPositionRo -> {
                mediaAdPositionRo.setMediaClass((String)map.get(mediaAdPositionRo.getMediaClass()));
                mediaAdPositionRo.setMediaChildClass((String)map.get(mediaAdPositionRo.getMediaChildClass()));
            });
            ((PageInfo)resultModel.getReturnValue()).setList(list);
        }
        return resultModel;
    }

    @RequestMapping(value={"/updateMaterialType"})
    public ResultModel<Boolean> updateMaterialType(@RequestParam(name="positionId") String positionId, @RequestParam(name="materialType") String materialType) {
        boolean result = this.newAppEntranceFacadeIntegration.updateMaterialType(positionId, materialType);
        if (!result) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return new ResultModel();
    }
}

