/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adflowpackage;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdFlowPackageNewVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowNewService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdTicketFlowNewController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketFlowNewController.class);
    @Autowired
    private AdTicketFlowNewService adTicketFlowNewService;

    @GetMapping(value={"/newpackage/findpackageMsg"}, produces={"application/json"})
    public ResultModel<List<AdFlowPackageNewVo>> findFlowPageIdByTicket(@RequestParam(value="ticketId", required=false) Long ticketId) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.adTicketFlowNewService.findFlowPageIdByTicket(ticketId));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/newpackage/findpackage"}, produces={"application/json"})
    public ResultModel<List<AdFlowPackageNewVo>> findPackageByCondition(@RequestParam(value="ticketId", required=false) Long ticketId, @RequestParam(value="type", defaultValue="cpc") String type) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.adTicketFlowNewService.findPackageByCondition(ticketId, type));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/newpackage/oldtonew"}, produces={"application/json"})
    public ResultModel<Boolean> oldToNew(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            this.adTicketFlowNewService.oldToNew(this.getUserName(request, response));
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setReturnValue((Object)false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    private String getUserName(HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user == null) {
            return "\u7528\u6237\u4e0d\u660e";
        }
        return user.getUsername();
    }
}

