/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidDTO;
import com.bxm.adsmanager.model.dto.AdAssetsConfigUidSearchDTO;
import com.bxm.adsmanager.model.vo.AdAssetsConfigUidVo;
import com.bxm.adsmanager.service.adkeeper.AdAssetsConfigUidService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssetsConfigUid"})
public class AdAssetsConfigUidController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsConfigUidController.class);
    @Autowired
    private AdAssetsConfigUidService adAssetsConfigUidService;

    @LogBefore(operType="/adAssetsConfigUid/add", keyName="\u5e7f\u544a\u7d20\u6750\u914d\u7f6e\u7528\u6237\u51fa\u4ef7\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@Validated @RequestBody AdAssetsConfigUidDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adAssetsConfigUidService.add(dto, user);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adAssetsConfigUid/updateStatus", keyName="\u5e7f\u544a\u7d20\u6750\u914d\u7f6e\u7528\u6237\u51fa\u4ef7\u72b6\u6001\u4fee\u6539")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.PUT})
    public ResultModel updateStatus(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long id, @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="status") @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") Short status, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adAssetsConfigUidService.updateStatus(id, status, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAll(HttpServletRequest request, HttpServletResponse response, AdAssetsConfigUidSearchDTO searchDTO) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.adAssetsConfigUidService.findPage(searchDTO);
            return ResultModelFactory.SUCCESS((Serializable)result);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResultModel<AdAssetsConfigUidVo> get(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long id) {
        ResultModel rs = new ResultModel();
        try {
            AdAssetsConfigUidVo result = this.adAssetsConfigUidService.get(id);
            return ResultModelFactory.SUCCESS((Serializable)result);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adAssetsConfigUid/update", keyName="\u5e7f\u544a\u7d20\u6750\u914d\u7f6e\u7528\u6237\u51fa\u4ef7\u4fee\u6539")
    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    public ResultModel updateStatus(@Validated @RequestBody AdAssetsConfigUidDTO dto, HttpServletRequest request, HttpServletResponse response) {
        if (dto.getId() == null) {
            return ResultModelFactory.FAIL500((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.getUser(request, response);
        try {
            this.adAssetsConfigUidService.update(dto, user);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adAssetsConfigUid/delete", keyName="\u5e7f\u544a\u7d20\u6750\u914d\u7f6e\u7528\u6237\u51fa\u4ef7\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adAssetsConfigUidService.delete(id, user);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }
}

