/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssetsCoupons"})
public class AdAssetsCouponsController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsCouponsController.class);
    @Autowired
    private AdTicketAssetsCouponsService adTicketAssetsCouponsService;
    @Autowired
    private AdTicketService adTicketService;

    @LogBefore(operType="/adAssetsCoupons/add", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel addAssets(HttpServletRequest request, HttpServletResponse response, String adAssetsCouponsListConf) {
        ResultModel rs = new ResultModel();
        try {
            List list = JSONArray.parseArray((String)adAssetsCouponsListConf, AdAssetsCoupons.class);
            if (list.isEmpty()) {
                return ResultModelFactory.FAIL400((String)"\u53c2\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            }
            for (AdAssetsCoupons adAssetsCoupons : list) {
                if (!(rs = this.checkParam(rs, adAssetsCoupons)).isSuccessed()) {
                    return rs;
                }
                Long ticketId = -1L;
                adAssetsCoupons.setTicketId(ticketId);
                adAssetsCoupons.setCreateUser(this.getUser(request, response).getUsername());
                adAssetsCoupons.setCreateTime(new Date());
            }
            this.adTicketAssetsCouponsService.add(list);
            Long[] ids = (Long[])list.stream().map(u -> u.getId()).toArray(Long[]::new);
            rs.setReturnValue((Object)ids);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssetsCoupons/addNew", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/addNew"}, method={RequestMethod.POST})
    public ResultModel addNew(HttpServletRequest request, HttpServletResponse response, String adAssetsCouponsListConf, Long ticketId) {
        ResultModel rs = new ResultModel();
        try {
            List list = JSONArray.parseArray((String)adAssetsCouponsListConf, AdAssetsCoupons.class);
            if (list.isEmpty()) {
                return ResultModelFactory.FAIL400((String)"\u53c2\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            }
            for (AdAssetsCoupons adAssetsCoupons : list) {
                if (!(rs = this.checkParam(rs, adAssetsCoupons)).isSuccessed()) {
                    return rs;
                }
                adAssetsCoupons.setTicketId(ticketId);
                adAssetsCoupons.setCreateUser(this.getUser(request, response).getUsername());
                adAssetsCoupons.setCreateTime(new Date());
            }
            this.adTicketAssetsCouponsService.addNew(list, ticketId);
            Long[] ids = (Long[])list.stream().map(u -> u.getId()).toArray(Long[]::new);
            rs.setReturnValue((Object)ids);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adTicketAssetsCouponsService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsById"}, method={RequestMethod.GET})
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = this.adTicketAssetsCouponsService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssetsCoupons/update", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel updateAllAssets(HttpServletRequest request, HttpServletResponse response, AdAssetsCoupons adAssetsCoupons, Long ticketId) {
        ResultModel rs = new ResultModel();
        Object result = null;
        try {
            if (adAssetsCoupons == null || adAssetsCoupons.getId() == null) {
                return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!(rs = this.checkParam(rs, adAssetsCoupons)).isSuccessed()) {
                return rs;
            }
            adAssetsCoupons.setModifyUser(this.getUser(request, response).getUsername());
            result = this.adTicketService.checkTagNeedAudit(Integer.valueOf(ticketId.intValue())) != false ? this.adTicketAssetsCouponsService.updateAndAudit(adAssetsCoupons, this.getUser(request, response)) : this.adTicketAssetsCouponsService.update(adAssetsCoupons);
            if (result != null) {
                rs.setSuccessed(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        rs.setReturnValue(result);
        return rs;
    }

    public <T> ResultModel checkParam(ResultModel<T> rs, AdAssetsCoupons adAssetsCoupons) {
        if (BeanValidator.validateGroup((Object)adAssetsCoupons, (Class[])new Class[]{AdAssets.Add.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adAssetsCoupons, (Class[])new Class[]{AdAssetsCoupons.Add.class}).getMessage());
        }
        if (adAssetsCoupons.getType() == 2 && StringUtils.isBlank((CharSequence)adAssetsCoupons.getImage2())) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u5c55\u793a\u7d20\u6750\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return rs;
    }
}

