/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateSearchDTO;
import com.bxm.adsmanager.model.vo.AdAssetsTemplateVO;
import com.bxm.adsmanager.service.adkeeper.AdAssetsTemplateService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssetsTemplate"})
public class AdAssetsTemplateController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsTemplateController.class);
    @Autowired
    private AdAssetsTemplateService adAssetsTemplateService;

    @LogBefore(operType="/adAssetsTemplate/add", keyName="\u7d20\u6750\u6a21\u677f\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@Validated @RequestBody AdAssetsTemplateDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setCreateUser(user.getUsername());
        return ResultModelFactory.SUCCESS((Serializable)this.adAssetsTemplateService.add(dto));
    }

    @LogBefore(operType="/adAssetsTemplate/updateStatus", keyName="\u7d20\u6750\u6a21\u677f\u72b6\u6001\u4fee\u6539")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.PUT})
    public ResultModel updateStatus(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long id, @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="status") @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") Short status, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adAssetsTemplateService.updateStatus(id, status, user.getUsername());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAll() {
        ResultModel rs = new ResultModel();
        try {
            List list;
            AdAssetsTemplateSearchDTO searchDTO = new AdAssetsTemplateSearchDTO();
            searchDTO.setStatus(Short.valueOf((short)1));
            searchDTO.setPageNum(Integer.valueOf(1));
            searchDTO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            PageInfo pageInfo = this.adAssetsTemplateService.findPage(searchDTO);
            if (pageInfo != null) {
                rs.setSuccessed(true);
            }
            if (null == (list = pageInfo.getList())) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllByTicketPositionAssociations"}, method={RequestMethod.GET})
    public ResultModel findAllByTicketPositionAssociations(@NotNull(message="\u5238Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="ticketId") @NotNull(message="\u5238Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long ticketId) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adAssetsTemplateService.findAllByTicketPositionAssociations(ticketId);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllByParams"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAllByParams(HttpServletRequest request, HttpServletResponse response, AdAssetsTemplateSearchDTO searchDTO) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo page = this.adAssetsTemplateService.findPage(searchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAssociationsPositionList"}, method={RequestMethod.GET})
    public ResultModel<List<AppEntranceAdRO>> findAssociationsPositionList(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long id) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adAssetsTemplateService.findAssociationsPositionList(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResultModel<AdAssetsTemplateVO> get(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Long id) {
        ResultModel rs = new ResultModel();
        try {
            AdAssetsTemplateVO adAssetsTemplateVo = this.adAssetsTemplateService.get(id);
            if (adAssetsTemplateVo != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)adAssetsTemplateVo);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u7d20\u6750\u6a21\u677f\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssetsTemplate/delete", keyName="\u7d20\u6750\u6a21\u677f\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(Long id) {
        try {
            this.adAssetsTemplateService.delete(id);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7d20\u6750\u6a21\u677f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u8be5\u4eba\u7fa4\u5305\u5df2\u88ab\u5e7f\u544a\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002");
        }
    }
}

