/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.adkeeper.AdTicketNewService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicket"})
public class AdTicketNewController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdTicketNewController.class);
    @Autowired
    private AdTicketNewService adTicketNewService;
    @Autowired
    private ProdService prodService;

    @LogBefore(operType="/adTicket/updateBudgetDaily", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateBudgetDaily"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel updateBudgetDaily(@RequestParam(value="id") Long id, @RequestParam(value="budgetDaily", required=false) Double budgetDaily, @RequestParam(value="price", required=false) Double price, @RequestParam(value="adxBudgetDaily", required=false) Double adxBudgetDaily, @RequestParam(value="adxPrice", required=false) Double adxPrice, HttpServletRequest request, HttpServletResponse response) {
        Boolean result;
        try {
            this.checkUpdateBudgetDaily(budgetDaily, price, adxBudgetDaily, adxPrice);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        User user = this.getUser(request, response);
        try {
            result = this.adTicketNewService.updateBudget(id, budgetDaily, price, adxBudgetDaily, adxPrice, user.getUsername());
            if (result.booleanValue()) {
                this.prodService.pushAdTicketToProdPre(id);
            }
        }
        catch (ValidateException e) {
            log.error("\u4fee\u6539\u65e5\u9884\u7b97\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u65e5\u9884\u7b97\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u65e5\u9884\u7b97\u9519\u8bef");
        }
        if (!result.booleanValue()) {
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u65e5\u9884\u7b97\u5931\u8d25");
        }
        return ResultModelFactory.SUCCESS();
    }

    private void checkUpdateBudgetDaily(Double budgetDaily, Double price, Double adxBudgetDaily, Double adxPrice) {
        if (budgetDaily == null && price == null && adxBudgetDaily == null && adxPrice == null) {
            throw new ValidateException("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (price != null && price < 0.001) {
            throw new ValidateException("\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0.001");
        }
        if (adxBudgetDaily != null && adxBudgetDaily < 0.01) {
            throw new ValidateException("ADX\u65e5\u9884\u7b97\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0.01");
        }
        if (adxPrice != null && adxPrice < 0.01) {
            throw new ValidateException("ADX\u51fa\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0.01");
        }
    }
}

