/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketRights;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketRightsDto;
import com.bxm.adsmanager.service.adkeeper.AdTicketRightsService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicket/rights"})
public class AdTicketRightsController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketRightsController.class);
    @Autowired
    private AdTicketRightsService adTicketRightsService;

    @LogBefore(operType="/adTicketRights/add", keyName="\u6743\u76ca\u5956\u54c1\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(@RequestBody AdTicketRightsDto adTicketRightsDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            if (BeanValidator.validateGroup((Object)adTicketRightsDto, (Class[])new Class[]{AdTicketRightsDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adTicketRightsDto, (Class[])new Class[]{AdTicketRightsDto.Add.class}).getMessage());
            }
            adTicketRightsDto.setCreateTime(new Date());
            adTicketRightsDto.setCreateUser(user.getUsername());
            Long positionAssetSizeId = this.adTicketRightsService.add(adTicketRightsDto);
            return ResultModelFactory.SUCCESS((Serializable)positionAssetSizeId);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u6743\u76ca\u5956\u54c1\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u6743\u76ca\u5956\u54c1\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adTicketRights/update", keyName="\u6743\u76ca\u5956\u54c1\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(@RequestBody AdTicketRightsDto adTicketRightsDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        if (adTicketRightsDto == null || adTicketRightsDto.getId() == null) {
            return ResultModelFactory.FAIL400((String)"\u6743\u76ca\u5956\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (BeanValidator.validateGroup((Object)adTicketRightsDto, (Class[])new Class[]{AdTicketRightsDto.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adTicketRightsDto, (Class[])new Class[]{AdTicketRightsDto.Update.class}).getMessage());
            }
            adTicketRightsDto.setModifyTime(new Date());
            adTicketRightsDto.setModifyUser(user.getUsername());
            Integer result = this.adTicketRightsService.update(adTicketRightsDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u6743\u76ca\u5956\u54c1\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u6743\u76ca\u5956\u54c1\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdTicketRights>> findAll(AdTicketRightsDto searchDto) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.adTicketRightsService.findAll(searchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6743\u76ca\u5956\u54c1\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6743\u76ca\u5956\u54c1\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findList"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketRights>> findList(AdTicketRightsDto searchDto) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adTicketRightsService.getList(searchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6240\u6709\u6743\u76ca\u5956\u54c1\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u67e5\u627e\u6240\u6709\u6743\u76ca\u5956\u54c1\u51fa\u9519");
        }
        return rs;
    }
}

