/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.dto.DirectTicketSearch;
import com.bxm.adsmanager.model.vo.AdAssetsVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.DirectTicketMaterialService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/directTicketMaterial"})
public class DirectTicketMaterialController
extends BaseController {
    @Autowired
    private DirectTicketMaterialService directTicketMaterialService;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectTicketMaterialController.class);

    @RequestMapping(value={"/findMaterials"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findMaterials(HttpServletRequest request, HttpServletResponse response, AdAssetsDto adAssetsDto) {
        ResultModel rs = new ResultModel();
        if (adAssetsDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400((String)"\u793c\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtil.isNotBlank((CharSequence)adAssetsDto.getAssetSize())) {
            return ResultModelFactory.FAIL400((String)"\u5c3a\u5bf8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (adAssetsDto.getPvStartTime() == null || adAssetsDto.getPvEndTime() == null) {
            return ResultModelFactory.FAIL400((String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Pagination list = this.directTicketMaterialService.findDirectAssetsListByParams(adAssetsDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u548c\u5c3a\u5bf8\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u548c\u5c3a\u5bf8\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findTickets"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findTickets(HttpServletRequest request, HttpServletResponse response, DirectTicketSearch directTicketSearch) {
        ResultModel rs = new ResultModel();
        if (directTicketSearch.getPvStartTime() == null || directTicketSearch.getPvEndTime() == null) {
            return ResultModelFactory.FAIL400((String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Pagination list = this.directTicketMaterialService.findDirectTickets(directTicketSearch);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u76f4\u6295\u5e7f\u544a\u5238X\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u76f4\u6295\u5e7f\u544a\u5238X\u5c3a\u5bf8\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdAssetsDto AdAssetsDto2) {
        ResultModel rs = new ResultModel();
        try {
            String userName = this.getUser(request, response).getUsername();
            this.directTicketMaterialService.add(AdAssetsDto2, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u76f4\u6295\u5e7f\u544a\u5238X\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u76f4\u6295\u5e7f\u544a\u5238X\u5c3a\u5bf8\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdAssetsDto AdAssetsDto2) {
        ResultModel rs = new ResultModel();
        try {
            String userName = this.getUser(request, response).getUsername();
            this.directTicketMaterialService.update(AdAssetsDto2, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u76f4\u6295\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u76f4\u6295\u7d20\u6750\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel get(Long id) {
        ResultModel rs = new ResultModel();
        try {
            AdAssetsVo adAssetsVo = this.directTicketMaterialService.get(id);
            rs.setReturnValue((Object)adAssetsVo);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5355\u4e2a\u76f4\u6295\u7d20\u6750\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u5355\u4e2a\u76f4\u6295\u7d20\u6750\u4fe1\u606f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel delete(Long id) {
        ResultModel rs = new ResultModel();
        try {
            this.directTicketMaterialService.delete(id);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5355\u4e2a\u76f4\u6295\u7d20\u6750\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5355\u4e2a\u76f4\u6295\u7d20\u6750\u4fe1\u606f\u51fa\u9519");
        }
    }
}

