/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dao.adkeeper.DownloadLandingPage;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.DownloadLandingPageDTO;
import com.bxm.adsmanager.model.dto.DownloadLandingPageSearchDTO;
import com.bxm.adsmanager.service.adkeeper.DownloadLandingPageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/downloadLandingPage"})
public class DownloadLandingPageController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadLandingPageController.class);
    @Autowired
    private DownloadLandingPageService downloadLandingPageService;

    @LogBefore(operType="/downloadLandingPage/add", keyName="\u4e0b\u8f7d\u843d\u5730\u9875\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(@RequestBody DownloadLandingPageDTO downloadLandingPageDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            if (BeanValidator.validateGroup((Object)downloadLandingPageDto, (Class[])new Class[]{DownloadLandingPageDTO.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)downloadLandingPageDto, (Class[])new Class[]{DownloadLandingPageDTO.Add.class}).getMessage());
            }
            Long positionAssetSizeId = this.downloadLandingPageService.add(downloadLandingPageDto);
            return ResultModelFactory.SUCCESS((Serializable)positionAssetSizeId);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519");
        }
    }

    @LogBefore(operType="/downloadLandingPage/update", keyName="\u4e0b\u8f7d\u843d\u5730\u9875\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(@RequestBody DownloadLandingPageDTO downloadLandingPageDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        if (downloadLandingPageDto == null || downloadLandingPageDto.getId() == null) {
            return ResultModelFactory.FAIL400((String)"\u4e0b\u8f7d\u843d\u5730\u9875id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (BeanValidator.validateGroup((Object)downloadLandingPageDto, (Class[])new Class[]{DownloadLandingPageDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)downloadLandingPageDto, (Class[])new Class[]{DownloadLandingPageDTO.Update.class}).getMessage());
            }
            Integer result = this.downloadLandingPageService.update(downloadLandingPageDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<DownloadLandingPage>> findAll(DownloadLandingPageSearchDTO searchDto) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.downloadLandingPageService.findAll(searchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findList"}, method={RequestMethod.GET})
    public ResultModel<List<DownloadLandingPage>> findList(DownloadLandingPageSearchDTO searchDto) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.downloadLandingPageService.getList(searchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6240\u6709\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u67e5\u627e\u6240\u6709\u4e0b\u8f7d\u843d\u5730\u9875\u51fa\u9519");
        }
        return rs;
    }
}

