/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.InnerCrowdPackageDto;
import com.bxm.adsmanager.model.dto.InnerCrowdPackageSearchDto;
import com.bxm.adsmanager.service.adkeeper.InnerCrowdPackageService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/innerCrowdPackage"})
@RestController
public class InnerCrowdPackageController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(InnerCrowdPackageController.class);
    @Autowired
    private InnerCrowdPackageService innerCrowdPackageService;

    @GetMapping(value={"/list"})
    public ResultModel list(InnerCrowdPackageSearchDto dto) {
        return ResultModelFactory.SUCCESS((Serializable)this.innerCrowdPackageService.list(dto));
    }

    @LogBefore(operType="/innerCrowdPackage/add", keyName="\u5185\u90e8\u4eba\u7fa4\u5305\u65b0\u589e")
    @PostMapping(value={"/add"})
    public ResultModel add(@Validated InnerCrowdPackageDto dto) {
        try {
            dto.setUserName(RequestUtils.getCurrentUserName());
            this.innerCrowdPackageService.add(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/innerCrowdPackage/update", keyName="\u5185\u90e8\u4eba\u7fa4\u5305\u4fee\u6539")
    @PostMapping(value={"/update"})
    public ResultModel update(@Validated InnerCrowdPackageDto dto) {
        try {
            dto.setUserName(RequestUtils.getCurrentUserName());
            this.innerCrowdPackageService.update(dto);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/innerCrowdPackage/updateStatus", keyName="\u5185\u90e8\u4eba\u7fa4\u5305\u72b6\u6001\u4fee\u6539")
    @PutMapping(value={"/updateStatus"})
    public ResultModel updateStatus(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Integer id, @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="status") @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01") Short status, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.innerCrowdPackageService.updateStatus(id, status, user.getUsername());
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }
}

