/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dto.LandingPagePlanDto;
import com.bxm.adsmanager.model.dto.LandingPagePlanSearchDto;
import com.bxm.adsmanager.model.vo.LandingPageConfigVo;
import com.bxm.adsmanager.service.adkeeper.LandingPageService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/landingPagePlan"})
@RestController
public class LandingPageController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(LandingPageController.class);
    @Autowired
    private LandingPageService landingPageService;

    @GetMapping(value={"/list"})
    public ResultModel list(LandingPagePlanSearchDto dto) {
        PageInfo list = this.landingPageService.list(dto);
        return ResultModelFactory.SUCCESS((Object)list);
    }

    @PostMapping(value={"/add"})
    public ResultModel add(@Validated LandingPagePlanDto dto) {
        String landingPageConfigs = dto.getLandingPageConfigs();
        dto.setLandingPageConfigVoList(JSON.parseArray((String)landingPageConfigs, LandingPageConfigVo.class));
        if (this.checkParam(dto) != null) {
            return this.checkParam(dto);
        }
        try {
            this.landingPageService.add(dto, RequestUtils.getCurrentUserName());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/update"})
    public ResultModel update(@Validated LandingPagePlanDto dto) {
        String landingPageConfigs = dto.getLandingPageConfigs();
        dto.setLandingPageConfigVoList(JSON.parseArray((String)landingPageConfigs, LandingPageConfigVo.class));
        if (this.checkParam(dto) != null) {
            return this.checkParam(dto);
        }
        if (dto.getId() == null) {
            return ResultModelFactory.FAILED400((String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.landingPageService.update(dto, RequestUtils.getCurrentUserName());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/updateStatus"})
    public ResultModel updateStatus(@RequestParam(value="id") Long id, @RequestParam(value="status") Short status) {
        try {
            this.landingPageService.updateStatus(id, status);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/enableKylin"})
    public ResultModel enableKylin(@RequestParam(value="id") Long id, @RequestParam(value="landPageId") Long landPageId, @RequestParam(value="enableKylin") Short enableKylin) {
        try {
            this.landingPageService.enableKylin(id, landPageId, enableKylin);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    private ResultModel checkParam(LandingPagePlanDto dto) {
        List landingPageConfigs = dto.getLandingPageConfigVoList();
        if (landingPageConfigs == null) {
            return ResultModelFactory.FAILED400((String)"\u843d\u5730\u9875\u6d41\u91cf\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (LandingPageConfigVo landingPageConfig : landingPageConfigs) {
            Double flowRate = landingPageConfig.getFlowRate();
            if (flowRate == null) {
                return ResultModelFactory.FAILED400((String)"\u6d41\u91cf\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)landingPageConfig.getName())) {
                return ResultModelFactory.FAILED400((String)"\u843d\u5730\u9875\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)landingPageConfig.getUrl())) {
                return ResultModelFactory.FAILED400((String)"\u843d\u5730\u9875URL\u4e0d\u80fd\u4e3a\u7a7a");
            }
            nameSet.add(landingPageConfig.getName());
        }
        if (landingPageConfigs.size() != nameSet.size()) {
            return ResultModelFactory.FAILED400((String)"\u8f93\u5165\u7684\u843d\u5730\u9875\u540d\u79f0\u4e0d\u80fd\u76f8\u540c");
        }
        return null;
    }

    @PostMapping(value={"/updateFlowRate"})
    public ResultModel updateFlowRate(@RequestParam(value="ticketId") Long ticketId, @RequestParam(value="landingPageConfigId") Long landingPageConfigId, @RequestParam(value="flowRate") Double flowRate) {
        try {
            this.landingPageService.updateFlowRate(ticketId, landingPageConfigId, flowRate);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAILED500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAILED500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
    }
}

