/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.mobile.TicketQueryConditionDTO;
import com.bxm.adsmanager.model.dto.mobile.TicketUpdateDTO;
import com.bxm.adsmanager.model.enums.TicketStatusEnum;
import com.bxm.adsmanager.model.vo.mobile.TicketDetailVO;
import com.bxm.adsmanager.service.adkeeper.mobile.MobileAdTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/ticket"})
public class MobileAdTicketController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MobileAdTicketController.class);
    @Autowired
    private MobileAdTicketService mobileAdTicketService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAll(TicketQueryConditionDTO conditionDTO, HttpServletResponse response, HttpServletRequest request) {
        ResultModel resultModel = new ResultModel();
        try {
            UserVo userVo = (UserVo)request.getAttribute("user");
            if (userVo == null || StringUtils.isBlank((CharSequence)userVo.getUsername())) {
                return ResultModelFactory.FAIL500((String)"\u672a\u767b\u5f55");
            }
            resultModel.setReturnValue((Object)this.mobileAdTicketService.findAll(conditionDTO, (UserVo)request.getAttribute("user")));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6240\u6709\u5238\u5f02\u5e38\uff01", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return resultModel;
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public ResultModel<TicketDetailVO> detail(@RequestParam(name="id") Long id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.mobileAdTicketService.detail(id));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5238\u8be6\u60c5\u5f02\u5e38\uff01", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return resultModel;
    }

    @LogBefore(operType="/mobile/ticket/update", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel<Boolean> update(HttpServletRequest request, HttpServletResponse response, TicketUpdateDTO updateDTO) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel resultModel = new ResultModel();
        try {
            if (BeanValidator.validateGroup((Object)updateDTO, (Class[])new Class[0]) != null) {
                return ResultModelFactory.FAIL400((String)Objects.requireNonNull(BeanValidator.validateGroup((Object)updateDTO, (Class[])new Class[0])).getMessage());
            }
            UserVo userVo = (UserVo)request.getAttribute("user");
            if (userVo == null || StringUtils.isBlank((CharSequence)userVo.getUsername())) {
                return ResultModelFactory.FAIL500((String)"\u672a\u767b\u5f55");
            }
            resultModel.setReturnValue((Object)this.mobileAdTicketService.update(updateDTO, userVo));
            this.addLogs(this.getUser(request, response), "[\u79fb\u52a8\u7aef]\u7f16\u8f91\uff1a" + JSON.toJSONString((Object)updateDTO), updateDTO.getId() + "");
            this.addMobileTicketNewLogs(this.getUser(request, response), updateDTO);
            return resultModel;
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519\uff1a" + e.getMessage()));
        }
    }

    private void addMobileTicketNewLogs(User user, TicketUpdateDTO updateDTO) {
        String log = "";
        try {
            String priceStr;
            String oldPriceStr;
            if (updateDTO == null) {
                return;
            }
            BigDecimal oldPrice = updateDTO.getOldPrice();
            BigDecimal price = updateDTO.getPrice();
            if (oldPrice != null && price != null && !(oldPriceStr = String.valueOf(oldPrice)).equals(priceStr = String.valueOf(price))) {
                log = log + "\u51fa\u4ef7\u4ece" + oldPriceStr + "\u8c03\u6574\u4e3a" + priceStr + ";";
            }
            if (StringUtils.isNotBlank((CharSequence)log)) {
                this.addNewLogs(user, "[\u79fb\u52a8\u7aef]\u7f16\u8f91\uff1a" + log, String.valueOf(updateDTO.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @LogBefore(operType="/mobile/ticket/updateStatus", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="id") Long id, @RequestParam(name="statusFlag") Integer statusFlag) {
        if (0 != statusFlag && 1 != statusFlag) {
            return ResultModelFactory.FAIL500((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570\uff01\uff01\uff01");
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            UserVo userVo = (UserVo)request.getAttribute("user");
            if (userVo == null || StringUtils.isBlank((CharSequence)userVo.getUsername())) {
                return ResultModelFactory.FAIL500((String)"\u672a\u767b\u5f55");
            }
            Short status = 1 == statusFlag ? TicketStatusEnum.NORMAL.getStatus().shortValue() : TicketStatusEnum.STOP.getStatus().shortValue();
            rs.setReturnValue((Object)this.mobileAdTicketService.updateStatus(id, status, userVo));
            this.addLogs(this.getUser(request, response), JSON.toJSONString((Object)(AdTicket.AdTicketStatus.getName((short)status) + "\u5e7f\u544a\u5238")), id + "");
            return rs;
        }
        catch (ValidateException v) {
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (PushProdException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519\uff1a" + e.getMessage()));
        }
    }
}

