/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.PanguCreative;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeBatchUpdateTagDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeDTO;
import com.bxm.adsmanager.model.dto.PanguCreativeSearchDTO;
import com.bxm.adsmanager.model.vo.PanguCreativeListVO;
import com.bxm.adsmanager.model.vo.PanguCreativeUploadResultVO;
import com.bxm.adsmanager.model.vo.UploadResultVO;
import com.bxm.adsmanager.service.adkeeper.PanguCreativeService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.GifDecoder;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/panguCreative"})
public class PanguCreativeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PanguCreativeController.class);
    @Autowired
    private PanguCreativeService panguCreativeService;
    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<PanguCreativeListVO>> findAll(PanguCreativeSearchDTO searchDTO, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            PageInfo result = this.panguCreativeService.findAll(user, searchDTO);
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)result);
            return rs;
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findSize"}, method={RequestMethod.GET})
    public ResultModel findSize(HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            List result = this.panguCreativeService.findSize(user);
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)result);
            return rs;
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResultModel<UploadResultVO> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map.Entry entity;
        MultipartFile file;
        Integer maxFileSize = 5120000;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity2 : fileMap.entrySet()) {
            MultipartFile file2 = (MultipartFile)entity2.getValue();
            if (file2.getSize() <= (long)maxFileSize.intValue()) continue;
            String originalFilename = file2.getOriginalFilename();
            throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6[" + originalFilename + "]\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc75000K\uff01");
        }
        PanguCreativeUploadResultVO uploadResultVO = new PanguCreativeUploadResultVO();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext() && (file = (MultipartFile)(entity = iterator.next()).getValue()) != null) {
            Object sourceImg;
            String fileName = file.getOriginalFilename();
            byte[] bytes = file.getBytes();
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            int width = 0;
            int height = 0;
            if ("gif".equalsIgnoreCase(suffix)) {
                sourceImg = GifDecoder.read((InputStream)file.getInputStream());
                width = sourceImg.getWidth();
                height = sourceImg.getHeight();
            } else {
                sourceImg = ImageIO.read(file.getInputStream());
                width = ((BufferedImage)sourceImg).getWidth();
                height = ((BufferedImage)sourceImg).getHeight();
            }
            uploadResultVO.setFileName(file.getOriginalFilename());
            uploadResultVO.setMd5(DigestUtils.md5DigestAsHex((byte[])bytes));
            this.panguCreativeService.fillCreativeInfo(uploadResultVO, width, height);
            if (!uploadResultVO.getFileExist().booleanValue() && uploadResultVO.getFileSizeExist().booleanValue() && StringUtils.isNotBlank((CharSequence)fileName)) {
                File newFile = new File(fileName);
                try {
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    FileOutputStream outStream = new FileOutputStream(newFile);
                    outStream.write(bytes);
                    outStream.close();
                    file.transferTo(newFile);
                    String uploadUrl = AliOSSUtil.upload((String)this.accessKeyId, (String)this.secret, (File)newFile, (String)this.bucketName, (String)this.fileHost, null);
                    uploadResultVO.setUrl(uploadUrl);
                }
                finally {
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                }
            }
        }
        return ResultModelFactory.SUCCESS((Serializable)uploadResultVO);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel<ArrayList<PanguCreative>> add(@RequestBody @Validated PanguCreativeDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)this.panguCreativeService.add(user, dto));
            return rs;
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @LogBefore(operType="/panguCreative/batchUpdateStatus", keyName="\u6279\u91cf\u66f4\u65b0\u72b6\u6001")
    @RequestMapping(value={"/batchUpdateStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Boolean> batchUpdateStatus(@RequestBody PanguCreativeBatchUpdateStatusDTO dto, HttpServletRequest request, HttpServletResponse response) {
        if (BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{PanguCreativeBatchUpdateStatusDTO.Update.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{PanguCreativeBatchUpdateStatusDTO.Update.class}).getMessage());
        }
        User user = this.getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)this.panguCreativeService.batchUpdateStatus(user, dto));
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u66f4\u65b0\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL400((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u6279\u91cf\u66f4\u65b0\u72b6\u6001\u51fa\u9519");
        }
    }

    @LogBefore(operType="/panguCreative/batchUpdateTag", keyName="\u6279\u91cf\u66f4\u65b0\u6807\u7b7e")
    @RequestMapping(value={"/batchUpdateTag"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Boolean> batchUpdateTag(@RequestBody PanguCreativeBatchUpdateTagDTO dto, HttpServletRequest request, HttpServletResponse response) {
        if (BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{PanguCreativeBatchUpdateTagDTO.Update.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{PanguCreativeBatchUpdateTagDTO.Update.class}).getMessage());
        }
        User user = this.getUser(request, response);
        try {
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)this.panguCreativeService.batchUpdateTag(user, dto));
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u66f4\u65b0\u6807\u7b7e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL400((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u6279\u91cf\u66f4\u65b0\u6807\u7b7e\u51fa\u9519");
        }
    }
}

