/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adposition;

import com.bxm.activites.facade.service.ActivityBackService;
import com.bxm.adapi.facade.model.ResultModel;
import com.bxm.adapi.model.EnhanceResultModel;
import com.bxm.adapi.model.exception.AdApiCodeType;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.position.AuditAdPositionDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.ro.AppEntranceEditRo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAuditVO;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@EnableAutoConfiguration
@RefreshScope
@RequestMapping(value={"/adPositionAudit"})
public class AdPositionAuditController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionAuditController.class);
    @Resource
    private AdPositionAuditService adPositionAuditService;
    @Resource
    private ActivityBackService activityBackService;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private JedisUpdater jedisUpdater;

    @RequestMapping(value={"/getAuditPage"}, method={RequestMethod.GET})
    com.bxm.util.dto.ResultModel<PageInfo<AppEntranceAuditVO>> getAuditPage(@RequestParam(name="keywords", required=false) String keywords, @RequestParam(name="status") Byte status, @RequestParam(name="providerId", required=false, defaultValue="-1") Long providerId, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="areaType", required=false) Integer areaType, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        Boolean look_all;
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(look_all = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS((Serializable)this.adPositionAuditService.getAuditPage(keywords, status, providerId, mjCode, areaType, pageNum, pageSize));
    }

    @LogBefore(operType="/adPositionAudit/positionSwitch", keyName="\u5e7f\u544a\u4f4d \u5f00\u542f/\u5173\u95ed")
    @RequestMapping(value={"/positionSwitch"}, method={RequestMethod.POST})
    com.bxm.util.dto.ResultModel<Boolean> positionSwitch(@RequestParam(value="positionId") String positionId, @RequestParam(value="closeFlag") Boolean closeFlag, HttpServletRequest request, HttpServletResponse response) {
        boolean result = this.newAppEntranceFacadeIntegration.positionSwitch(positionId, closeFlag, this.getUser(request, response).getUsername());
        if (!result) {
            throw new BusinessException("\u5f00\u5173\u5e7f\u544a\u4f4d\u5931\u8d25\uff01");
        }
        return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
    }

    @LogBefore(operType="/adPositionAudit/auditAdPosition", keyName="\u5ba1\u6838\u5e7f\u544a\u4f4d\u4fe1\u606f")
    @RequestMapping(value={"/auditAdPosition"}, method={RequestMethod.PUT}, produces={"application/json"})
    public com.bxm.util.dto.ResultModel<Boolean> auditAdPosition(AuditAdPositionDto dto, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!dto.getState().equals(1) && !dto.getState().equals(2)) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)dto.getIds())) {
            throw new BusinessException("id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String idsStr = Joiner.on((String)",").skipNulls().join((Iterable)dto.getIds());
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        Boolean isMJ = user.getRoleCodes().contains(RoleEnum.MJ.getCode()) || user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode());
        Boolean fk = user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        if (!(isMJ = Boolean.valueOf(isMJ != false && fk != false ? false : isMJ)).booleanValue() && !fk.booleanValue()) {
            throw new BusinessException("\u53ea\u6709\u5a92\u4ecb/\u5a92\u4ecb\u7ecf\u7406/\u98ce\u63a7\u89d2\u8272\u53ef\u4ee5\u64cd\u4f5c\u5ba1\u6838\uff01");
        }
        boolean auditPass = dto.getState().equals(1);
        List successIds = this.newAppEntranceFacadeIntegration.batchAudit(idsStr, Boolean.valueOf(auditPass), isMJ, dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
        if (CollectionUtils.isEmpty((Collection)successIds)) {
            throw new BusinessException("\u5ba1\u6838\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u9009\u62e9\u7684\u5e7f\u544a\u4f4d\u6240\u5728\u7684\u5a92\u4f53\u548c\u5f00\u53d1\u8005\u8d22\u52a1\u4fe1\u606f\u662f\u5426\u901a\u8fc7\u5ba1\u6838\u3002");
        }
        if (!auditPass) {
            return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
        }
        if (isMJ.booleanValue()) {
            isMJ = false;
            List fkAuditSuccessIds = this.newAppEntranceFacadeIntegration.batchAudit(idsStr, Boolean.valueOf(auditPass), isMJ, dto.getRefuseReason(), dto.getReviewRefuseIds(), user.getUsername());
            if (CollectionUtils.isEmpty((Collection)fkAuditSuccessIds)) {
                throw new BusinessException("\u5ba1\u6838\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u9009\u62e9\u7684\u5e7f\u544a\u4f4d\u6240\u5728\u7684\u5a92\u4f53\u548c\u5f00\u53d1\u8005\u8d22\u52a1\u4fe1\u606f\u662f\u5426\u901a\u8fc7\u5ba1\u6838\u3002");
            }
        }
        this.adPositionAuditService.positionAddTag(dto.getIds());
        return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
    }

    @LogBefore(operType="/adPositionAudit/updateAdPositionInfo", keyName="\u7f16\u8f91\u5e7f\u544a\u4f4d\u4fe1\u606f")
    @RequestMapping(value={"/updateAdPositionInfo"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> updateAdPositionInfo(HttpServletRequest request, AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        EnhanceResultModel result = new EnhanceResultModel();
        try {
            LOGGER.info("\u4fee\u6539\u5e7f\u544a\u4f4d\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570:{}", (Object)appEntranceEditRo);
            User user = this.getUser(request, null);
            if (appEntranceEditRo.getId() != null) {
                AppEntranceAdRO appEntrance = this.adPositionAuditService.findPositionById(appEntranceEditRo.getId());
                String oldCooperationType = appEntrance.getCooperationType();
                Byte newCooperationType = appEntranceEditRo.getCooperationType();
                Boolean isUpdateCooperationType = StringUtils.isNotBlank((String)oldCooperationType) && ObjectUtils.notEqual((Object)oldCooperationType, (Object)newCooperationType.toString());
                if (isUpdateCooperationType.booleanValue() && UserRoleCodeUtil.isNotMJLeader((User)user).booleanValue()) {
                    result.setSuccessed(false);
                    result.setErrorDesc("\u4ec5\u5a92\u4ecb\u7ecf\u7406\u6743\u9650\u53ef\u4ee5\u4fee\u6539\u5408\u4f5c\u7c7b\u578b");
                    return result;
                }
            }
            result.setReturnValue((Object)this.adPositionAuditService.updateAdPositionInfo(appEntranceEditRo, user.getUsername()));
        }
        catch (ValidateException e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            result = new ResultModel();
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u4fe1\u606f\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result = new EnhanceResultModel(AdApiCodeType.SYSTEM_ERROR, new String[0]);
        }
        return result;
    }

    @LogBefore(operType="/adPositionAudit/batchsaveOrUpdate", keyName="\u7f16\u8f91\u5e7f\u544a\u4f4d\u4fe1\u606f")
    @RequestMapping(value={"/batchsaveOrUpdate"}, produces={"application/json"})
    public com.bxm.util.dto.ResultModel<Boolean> batchsaveOrUpdate(HttpServletRequest request, AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        com.bxm.util.dto.ResultModel result = new com.bxm.util.dto.ResultModel();
        try {
            result.setReturnValue((Object)this.adPositionAuditService.batchsaveOrUpdate(appEntranceEditRo));
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u524d\u7f6e\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/updateOldKf"}, method={RequestMethod.GET}, produces={"application/json"})
    public com.bxm.util.dto.ResultModel<Boolean> updateOldKf(HttpServletRequest request) throws ValidateException {
        com.bxm.util.dto.ResultModel result = new com.bxm.util.dto.ResultModel();
        try {
            LOGGER.info("\u5f00\u59cb\u8ba2\u6b63\u5ba2\u670d\u6570\u636e\u9ed8\u8ba4\u914d\u7f6e");
            result.setReturnValue((Object)this.adPositionAuditService.updateOldKf());
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u6b63\u5ba2\u670d\u6570\u636e\u9ed8\u8ba4\u914d\u7f6e\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result.setSuccessed(false);
        }
        return result;
    }

    @LogBefore(operType="/adPositionAudit/updateAdPositionRewardConfigForExist", keyName="\u8ba2\u6b63\u5e7f\u544a\u4f4d\u6fc0\u52b1\u5238\u9ed8\u8ba4\u914d\u7f6e")
    @RequestMapping(value={"/updateAdPositionRewardConfigForExist"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Boolean> updateAdPositionRewardConfigForExist(HttpServletRequest request) throws ValidateException {
        EnhanceResultModel result = new EnhanceResultModel();
        try {
            LOGGER.info("\u5f00\u59cb\u8ba2\u6b63\u5e7f\u544a\u4f4d\u6fc0\u52b1\u5238\u9ed8\u8ba4\u914d\u7f6e");
            result.setReturnValue((Object)this.adPositionAuditService.saveOrUpdateAdPositionInfoForExist());
        }
        catch (ValidateException e) {
            LOGGER.error("\u8ba2\u6b63\u5e7f\u544a\u4f4d\u6fc0\u52b1\u5238\u9ed8\u8ba4\u914d\u7f6e\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u6b63\u5e7f\u544a\u4f4d\u6fc0\u52b1\u5238\u9ed8\u8ba4\u914d\u7f6e\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result.setSuccessed(false);
        }
        return result;
    }

    @LogBefore(operType="/adPositionAudit/updatePositionDomainCode", keyName="\u7ba1\u7406\u5e7f\u544a\u4f4d\u884c\u4e1a\u6807\u7b7e")
    @RequestMapping(value={"/updatePositionDomainCode"}, method={RequestMethod.GET}, produces={"application/json"})
    public com.bxm.util.dto.ResultModel<String> updatePositionDomainCode(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="positionId") String positionId, @RequestParam(value="status") Integer status) throws Exception {
        com.bxm.util.dto.ResultModel resultModel = new com.bxm.util.dto.ResultModel();
        User user = this.getUser(request, null);
        if (user.getRoleCodes() != null && (user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RTB_LEADER.getCode()))) {
            if (status == 0) {
                this.jedisUpdater.hremove(CommonConstant.getKeyGeneratorByPositionDomainiCode(), new String[]{positionId});
            } else {
                this.jedisUpdater.hupdate(CommonConstant.getKeyGeneratorByPositionDomainiCode(), positionId, (Object)DateUtil.dateTo8String((Date)new Date()));
            }
            resultModel.setReturnValue((Object)"\u5f00\u542f\u6216\u8005\u5173\u95ed\u6210\u529f");
        } else {
            resultModel.setReturnValue((Object)"\u53ea\u6709\u5a92\u4ecb\u7ecf\u7406/RTB\u8fd0\u8425\u7ecf\u7406 \u6709\u6743\u9650\u6dfb\u52a0");
        }
        return resultModel;
    }

    @LogBefore(operType="/adPositionAudit/updateCouponsInfo", keyName="\u4fee\u6539\u5e7f\u544a\u4f4d\u7968\u5238\u4fe1\u606f")
    @RequestMapping(value={"/updateCouponsInfo"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> updateCouponsInfo(HttpServletRequest request, AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        EnhanceResultModel result = new EnhanceResultModel();
        try {
            User user = this.getUser(request, null);
            result.setReturnValue((Object)this.adPositionAuditService.updateCouponsInfo(appEntranceEditRo, user.getUsername()));
        }
        catch (ValidateException e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u7968\u5238\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            result = new ResultModel();
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u7968\u5238\u4fe1\u606f\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result = new EnhanceResultModel(AdApiCodeType.SYSTEM_ERROR, new String[0]);
        }
        return result;
    }

    @LogBefore(operType="/adPositionAudit/updatePutinTypeInfo", keyName="\u4fee\u6539\u5e7f\u544a\u4f4d\u6295\u653e\u4fe1\u606f")
    @RequestMapping(value={"/updatePutinTypeInfo"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> updatePutinTypeInfo(HttpServletRequest request, AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        EnhanceResultModel result = new EnhanceResultModel();
        try {
            User user = this.getUser(request, null);
            result.setReturnValue((Object)this.adPositionAuditService.updatePutinTypeInfo(appEntranceEditRo, user.getUsername()));
        }
        catch (ValidateException e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u6295\u653e\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            result = new ResultModel();
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u6295\u653e\u4fe1\u606f\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result = new EnhanceResultModel(AdApiCodeType.SYSTEM_ERROR, new String[0]);
        }
        return result;
    }

    @LogBefore(operType="/adPositionAudit/updateWechatMiniAppPutInfo", keyName="\u4fee\u6539\u5e7f\u544a\u4f4d\u5c0f\u7a0b\u5e8f\u6295\u653e\u4fe1\u606f")
    @RequestMapping(value={"/updateWechatMiniAppPutInfo"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResultModel<Boolean> updateWechatMiniAppPutInfo(HttpServletRequest request, AppEntranceEditRo appEntranceEditRo) throws ValidateException {
        EnhanceResultModel result = new EnhanceResultModel();
        try {
            User user = this.getUser(request, null);
            if (StringUtils.isEmpty((String)appEntranceEditRo.getAppKey()) || StringUtils.isEmpty((String)appEntranceEditRo.getBusiness())) {
                throw new ValidateException("appkey\u6216\u8005business\u4e3a\u7a7a");
            }
            String adPositionId = appEntranceEditRo.getAppKey().concat("-").concat(appEntranceEditRo.getBusiness());
            result.setReturnValue((Object)this.adPositionAuditService.updateWechatMiniAppPutInfo(adPositionId, appEntranceEditRo.getWechatMiniAppPutFlag(), user.getUsername()));
        }
        catch (ValidateException e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5c0f\u7a0b\u5e8f\u6295\u653e\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            result = new ResultModel();
            result.setSuccessed(false);
            result.setErrorDesc(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u5c0f\u7a0b\u5e8f\u6295\u653e\u4fe1\u606f\u53d1\u751f\u672a\u77e5\u9519\u8bef:", (Throwable)e);
            result = new EnhanceResultModel(AdApiCodeType.SYSTEM_ERROR, new String[0]);
        }
        return result;
    }
}

