/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adprofit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.adprofit.LocalCache;
import com.bxm.adsmanager.model.dao.position.PositionDefaultPercent;
import com.bxm.adsmanager.model.dao.position.PositionDefaultPercentVo;
import com.bxm.adsmanager.model.dao.report.InfoAppMsg;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdMediaPositionProfitSearchDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitMediaDto;
import com.bxm.adsmanager.model.dto.adprofit.AdProfitPositionDto;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitAllVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitPositionVo;
import com.bxm.adsmanager.service.adprofit.AdProfitMediaPositionService;
import com.bxm.adsmanager.service.adprofit.impl.AdProfitMediaPositionCheckServiceImpl;
import com.bxm.adsmanager.utils.AppEntityConvertHelper;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ExcelUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.provider.ProviderAppAdDTO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RequestMapping(value={"/adProfitMediaPosition"})
@RestController
public class AdProfitMediaPositionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdProfitMediaPositionController.class);
    private static final int DEFULT_ONE = 1;
    @Autowired
    private AdProfitMediaPositionService adProfitMediaPositionService;
    @Autowired
    private AdProfitMediaPositionCheckServiceImpl adProfitMediaPositionCheckService;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<List<AdProfitAllVo>> findAll(HttpServletRequest request, HttpServletResponse response, AdMediaPositionProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            List lists = this.adProfitMediaPositionService.findAll(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u53d1\u8005\u603b\u6536\u76ca\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5f00\u53d1\u8005\u603b\u6536\u76ca\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findMediaProfit"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findMediaProfit(HttpServletRequest request, HttpServletResponse response, AdMediaPositionProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            Pagination lists = this.adProfitMediaPositionService.findMediaProfit(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u53d1\u8005\u6536\u76ca\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5f00\u53d1\u8005\u6536\u76ca\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findPositionProfit"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findPositionProfit(HttpServletRequest request, HttpServletResponse response, AdMediaPositionProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            Pagination lists = this.adProfitMediaPositionService.findPositionProfit(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u6536\u76ca\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u4f4d\u6536\u76ca\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/adProfitMediaPosition/importProfit")
    @RequestMapping(value={"/importProfit"}, method={RequestMethod.POST})
    @Deprecated
    public ResultModel<Pagination> importProfitExcel(HttpServletRequest request, HttpServletResponse response) {
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            User user = this.getUser(request, response);
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entity = iterator.next();
                MultipartFile file = (MultipartFile)entity.getValue();
                String originalFilename = file.getOriginalFilename();
                if (originalFilename.indexOf("\u5a92\u4f53\u6536\u76ca") != -1) {
                    LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
                    fieldMap.put("ID", "id");
                    fieldMap.put("\u65e5\u671f", "datetime");
                    fieldMap.put("\u5a92\u4f53ID", "appId");
                    fieldMap.put("\u9884\u4f30\u6536\u76ca", "profitPredict");
                    fieldMap.put("\u5b9e\u9645\u6536\u76ca", "profitActual");
                    fieldMap.put("\u5907\u6ce8", "remark");
                    List results = ExcelUtils.excelToList((InputStream)file.getInputStream(), (String)"\u5a92\u4f53\u6536\u76ca", AdProfitMediaDto.class, fieldMap, (int)1);
                    this.adProfitMediaPositionService.importAdProfitMediaExcel(user, results);
                    return ResultModelFactory.SUCCESS();
                }
                if (originalFilename.indexOf("\u5e7f\u544a\u4f4d\u6536\u76ca") != -1) {
                    LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
                    fieldMap.put("ID", "id");
                    fieldMap.put("\u65e5\u671f", "datetime");
                    fieldMap.put("\u5e7f\u544a\u4f4dID", "positionId");
                    fieldMap.put("\u5a92\u4f53ID", "appId");
                    fieldMap.put("\u9884\u4f30\u6536\u76ca", "profitPredict");
                    fieldMap.put("\u6263\u91cf\u91d1\u989d", "profitDeduct");
                    fieldMap.put("\u5907\u6ce8", "remark");
                    List results = ExcelUtils.excelToList((InputStream)file.getInputStream(), (String)"\u5e7f\u544a\u4f4d\u6536\u76ca", AdProfitPositionDto.class, fieldMap, (int)1);
                    this.adProfitMediaPositionService.importAdProfitPositionExcel(user, results);
                    return ResultModelFactory.SUCCESS();
                }
                return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5931\u8d25(\u8868\u683c\u540d\u79f0\u4e0d\u8bc6\u522b)");
            }
        }
        catch (ProfitException pe) {
            return ResultModelFactory.FAIL500((String)pe.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/adProfitMediaPosition/downLoadMedia")
    @RequestMapping(value={"/downLoadMedia"}, method={RequestMethod.GET})
    @Deprecated
    public ResultModel downLoadMediaExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime) {
        try {
            List list = this.adProfitMediaPositionService.downLoadMedia(datetime);
            ExcelUtil.exportExcel((List)list, null, (String)"\u5a92\u4f53\u6536\u76ca", AdProfitMediaVo.class, (String)("\u5a92\u4f53\u6536\u76ca" + datetime + ".xls"), (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4e0b\u8f7d\u5a92\u4f53\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/adProfitMediaPosition/downLoadPosition")
    @RequestMapping(value={"/downLoadPosition"}, method={RequestMethod.GET})
    @Deprecated
    public ResultModel downLoadPositionExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="appId") String appId) {
        try {
            List list = this.adProfitMediaPositionService.downLoadPosition(datetime, appId);
            ExcelUtil.exportExcel((List)list, null, (String)"\u5e7f\u544a\u4f4d\u6536\u76ca", AdProfitPositionVo.class, (String)("\u5e7f\u544a\u4f4d\u6536\u76ca" + datetime + ".xls"), (HttpServletResponse)response);
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4e0b\u8f7d\u5e7f\u544a\u4f4d\u6536\u76caExcel\u8868\u683c\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(keyName="\u5e7f\u544a", operType="/adProfitMediaPosition/entering")
    @RequestMapping(value={"/entering"}, method={RequestMethod.POST})
    public ResultModel entering(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="datetime") String datetime) {
        try {
            AdProfitMediaPositionController adProfitMediaPositionController = this;
            synchronized (adProfitMediaPositionController) {
                Boolean flag = (Boolean)LocalCache.map.get(datetime);
                if (flag != null && flag.booleanValue()) {
                    LOGGER.info("\u6570\u636e\u5728\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5,datetime:" + datetime);
                    return ResultModelFactory.FAIL400((String)"\u6570\u636e\u5728\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
                }
                LocalCache.map.put(datetime, true);
            }
            User user = this.getUser(request, response);
            this.adProfitMediaPositionService.entering(user, datetime);
            LocalCache.map.remove(datetime);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LocalCache.map.remove(datetime);
            LOGGER.error("\u793c\u5238\u6536\u76ca\u6536\u76ca\u5f55\u5165\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/mediaProfitByTime"}, method={RequestMethod.GET})
    public ResultModel<List<AdProfitMediaVo>> findMediaProfitByTime(HttpServletRequest request, HttpServletResponse response, AdMediaPositionProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        if (null == search || search != null && StringUtil.isBlank((CharSequence)search.getDatetime())) {
            LOGGER.error("\u5f00\u53d1\u8005\u6536\u76ca\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            rs.setSuccessed(false);
            rs.setErrorDesc("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return rs;
        }
        User user = this.getUser(request, response);
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isMj((User)user))) {
            search.setUserName(user.getUsername());
        }
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isBd((User)user))) {
            search.setBd(user.getUsername());
        }
        List lists = null;
        try {
            lists = this.adProfitMediaPositionService.selectMediaProfitByTime(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u53d1\u8005\u6536\u76ca\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5f00\u53d1\u8005\u6536\u76ca\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllMediaByRole"}, method={RequestMethod.GET})
    public ResultModel<List<InfoAppMsg>> findAllMediaByRole(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String keyWord) {
        ResultModel resultModel = new ResultModel();
        User user = this.getUser(httpServletRequest, httpServletResponse);
        ProviderAppAdDTO providerAppAdDto = new ProviderAppAdDTO();
        if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 && user.getRoleCodes().contains(RoleEnum.MJ.getCode())) {
            providerAppAdDto.setMedium(user.getUsername());
        }
        if (StringUtils.isNotEmpty((String)keyWord)) {
            providerAppAdDto.setKeywords(keyWord.trim());
        }
        resultModel.setReturnValue((Object)AppEntityConvertHelper.appListConvertToInfoAppMsgList((List)this.providerFacadeIntegration.getProviderAppList(providerAppAdDto)));
        return resultModel;
    }

    @RequestMapping(value={"/positionProfitByTime"}, method={RequestMethod.GET})
    public ResultModel<List<AdProfitPositionVo>> findPositionProfitByTime(HttpServletRequest request, HttpServletResponse response, AdMediaPositionProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        if (null == search || search != null && StringUtil.isBlank((CharSequence)search.getDatetime())) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u6536\u76ca\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            rs.setSuccessed(false);
            rs.setErrorDesc("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return rs;
        }
        User user = this.getUser(request, response);
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isMj((User)user))) {
            search.setUserName(user.getUsername());
        }
        if (StringUtils.isNotBlank((String)UserRoleCodeUtil.isBd((User)user))) {
            search.setBd(user.getUsername());
        }
        List lists = null;
        try {
            lists = this.adProfitMediaPositionService.selectPositionProfitByTime(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u6536\u76ca\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u4f4d\u6536\u76ca\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @LogBefore(keyName="\u5a92\u4f53", operType="/adProfitMediaPosition/mediaProfitByTime")
    @RequestMapping(value={"/mediaProfitByTime"}, method={RequestMethod.PUT})
    public ResultModel<String> updateMediaProfitByTime(HttpServletRequest request, HttpServletResponse response, @RequestBody String params, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="token") String token) {
        ResultModel checkAuth;
        List lists = null;
        ResultModel rs = new ResultModel();
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)params);
            lists = null != jsonObject ? JSON.parseArray((String)jsonObject.getString("data"), AdProfitMediaDto.class) : new ArrayList();
        }
        catch (Exception e) {
            rs.setSuccessed(false);
            rs.setErrorDesc("json\u89e3\u6790\u5f02\u5e38");
            return rs;
        }
        User user = this.getUser(request, response);
        if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 && user.getRoleCodes().contains(RoleEnum.MJ.getCode()) && !(checkAuth = this.adProfitMediaPositionCheckService.checkAuth(datetime)).isSuccessed()) {
            return checkAuth;
        }
        ResultModel checkMediaProfit = this.adProfitMediaPositionCheckService.checkMediaProfit(lists);
        if (!checkMediaProfit.isSuccessed()) {
            return checkMediaProfit;
        }
        try {
            this.adProfitMediaPositionService.updateAdProfitMedia(user, lists);
        }
        catch (ProfitException e) {
            LOGGER.error("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u4fee\u6539\u5f00\u53d1\u8005\u6536\u76ca\u9519\u8bef");
        }
        return rs;
    }

    @LogBefore(keyName="\u5e7f\u544a\u4f4d", operType="/adProfitMediaPosition/positionProfitByTime")
    @RequestMapping(value={"/positionProfitByTime"}, method={RequestMethod.PUT})
    public ResultModel<String> updatePositionProfitByTime(HttpServletRequest request, HttpServletResponse response, @RequestBody String params, @RequestParam(required=true, name="datetime") String datetime, @RequestParam(required=false, name="token") String token) {
        ResultModel checkAuth;
        List lists = null;
        ResultModel rs = new ResultModel();
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)params);
            lists = null != jsonObject ? JSON.parseArray((String)jsonObject.getString("data"), AdProfitPositionDto.class) : new ArrayList();
        }
        catch (Exception e) {
            rs.setSuccessed(false);
            rs.setErrorDesc("json\u89e3\u6790\u5f02\u5e38");
            return rs;
        }
        User user = this.getUser(request, response);
        if (user.getRoleCodes() != null && user.getRoleCodes().size() == 1 && user.getRoleCodes().contains(RoleEnum.MJ.getCode()) && !(checkAuth = this.adProfitMediaPositionCheckService.checkAuth(datetime)).isSuccessed()) {
            return checkAuth;
        }
        ResultModel checkPositionProfit = this.adProfitMediaPositionCheckService.checkPositionProfit(lists);
        if (!checkPositionProfit.isSuccessed()) {
            return checkPositionProfit;
        }
        try {
            this.adProfitMediaPositionService.updateAdProfitPosition(user, lists);
        }
        catch (ProfitException e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4f4d\u6536\u76ca\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u4fee\u6539\u5e7f\u544a\u4f4d\u6536\u76ca\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findDefaultPercent"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<PositionDefaultPercentVo>> findDefaultPercent(@RequestParam(value="appkeyName") String appkeyName, @RequestParam(value="positionName") String positionName, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        User user = this.getUser(request, response);
        try {
            rs.setReturnValue((Object)this.adProfitMediaPositionService.findDefaultPercent(user, appkeyName, positionName, pageNum, pageSize));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e7f\u544a\u4f4d\u9ed8\u8ba4\u5206\u6210\u6bd4\u4f8b\u5217\u8868\u83b7\u53d6\u5931\u8d25");
        }
        return rs;
    }

    @RequestMapping(value={"/findPercentByPositionIds"}, method={RequestMethod.POST})
    public ResultModel findPercentByPositionIds(@RequestParam(value="positionIds") String positionIds) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.adProfitMediaPositionService.findPercentByPositionId(positionIds));
        }
        catch (Exception e) {
            rs.setSuccessed(false);
            LOGGER.error("\u5e7f\u544a\u4f4d\u9ed8\u8ba4\u5206\u6210\u6bd4\u4f8b\u83b7\u53d6\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    @RequestMapping(value={"/updatePercentByPositionId"}, method={RequestMethod.POST})
    public ResultModel updatePercentByPositionId(PositionDefaultPercent positionDefaultPercent) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue((Object)this.adProfitMediaPositionService.updatePercentByPositionId(positionDefaultPercent));
        return rs;
    }
}

