/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.adsmanager.service.adsmedia.ArticleService;
import com.bxm.adsmedia.facade.model.article.ArticleDto;
import com.bxm.adsmedia.facade.model.article.ArticleRo;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RefreshScope
@RestController
@Api(description="\u6587\u7ae0\u7ba1\u7406")
@RequestMapping(value={"/article"})
public class ArticleController {
    @Autowired
    private ArticleService articleService;

    @ApiOperation(value="\u67e5\u8be2\u6587\u7ae0", notes="\u67e5\u8be2\u6587\u7ae0\u5217\u8868")
    @RequestMapping(value={"/getArticleList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ArticleRo>> getArticleList(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.articleService.getAppList(pageSize, pageNum));
        return resultModel;
    }

    @ApiOperation(value="\u65b0\u589e\u6587\u7ae0", notes="\u65b0\u589e\u6587\u7ae0")
    @RequestMapping(value={"/addArticle"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addArticle(@RequestParam(value="title") String title, @RequestParam(value="messageLink") String messageLink, @RequestParam(value="inserTime") String inserTime, @RequestParam(value="message") String message, @RequestParam(value="image") String image) {
        ResultModel resultModel = new ResultModel();
        ArticleDto article = new ArticleDto();
        article.setArticleTime(inserTime);
        article.setMessageLink(messageLink);
        article.setTitle(title);
        article.setMessage(message);
        article.setImage(image);
        this.articleService.addArticle(article);
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @ApiOperation(value="\u4fee\u6539\u6587\u7ae0", notes="\u4fee\u6539\u6587\u7ae0")
    @RequestMapping(value={"/updateArticle"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateArticle(ArticleDto articleDto, @RequestParam(value="inserTime", required=false) String inserTime) {
        ResultModel resultModel = new ResultModel();
        if (StringUtil.isNotBlank((CharSequence)inserTime)) {
            articleDto.setArticleTime(inserTime);
        }
        this.articleService.updateArticle(articleDto);
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @ApiOperation(value="\u5220\u9664\u6587\u7ae0", notes="\u5220\u9664\u6587\u7ae0")
    @RequestMapping(value={"/deleteArticle"}, method={RequestMethod.GET})
    public ResultModel<Boolean> deleteArticle(@RequestParam(value="id") String id) {
        ResultModel resultModel = new ResultModel();
        this.articleService.deleteArticle(Long.valueOf(Long.parseLong(id)));
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @ApiOperation(value="\u79fb\u52a8\u6587\u7ae0", notes="\u79fb\u52a8\u6587\u7ae0")
    @RequestMapping(value={"/moveArticle"}, method={RequestMethod.GET})
    public ResultModel<Boolean> moveArticle(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        ResultModel resultModel = new ResultModel();
        this.articleService.moveArticle(id, type);
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }
}

