/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.adsmanager.integration.adsmedia.appentrance.InspireVideoFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.enumdata.InspireVideoChannelEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceInspireVideoConfigDTO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceInspireVideoConfigVO;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inspireVideoConfig"})
public class InspireVideoConfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(InspireVideoConfigController.class);
    @Autowired
    private InspireVideoFacadeIntegration inspireVideoFacadeIntegration;

    @RequestMapping(value={"/addConfig"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public ResultModel<Boolean> addConfig(@RequestBody AppEntranceInspireVideoConfigDTO appEntranceInspireVideoConfigDTO, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            appEntranceInspireVideoConfigDTO.setModifier(user.getUsername());
            List configs = appEntranceInspireVideoConfigDTO.getConfigs();
            if (!this.validateConfigArgs(appEntranceInspireVideoConfigDTO)) {
                return ResultModelFactory.FAIL400((String)"\u8bf7\u68c0\u67e5\u53c2\u6570\u89c4\u5219\u6b63\u786e");
            }
            return this.inspireVideoFacadeIntegration.addConfig(appEntranceInspireVideoConfigDTO);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6fc0\u52b1\u6fc0\u52b1\u89c6\u9891\u6295\u653e\u914d\u7f6e\u65f6\u51fa\u9519\uff01", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4fdd\u5b58\u6fc0\u52b1\u6fc0\u52b1\u89c6\u9891\u6295\u653e\u914d\u7f6e\u65f6\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/getConfigList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResultModel<List<AppEntranceInspireVideoConfigVO>> getConfigList(@RequestParam(value="positionId") String positionId) {
        return this.inspireVideoFacadeIntegration.getConfigList(positionId);
    }

    boolean validateConfigArgs(AppEntranceInspireVideoConfigDTO dto) {
        String positionId = dto.getPositionId();
        List configs = dto.getConfigs();
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return false;
        }
        if (StringUtils.isBlank((String)positionId)) {
            return false;
        }
        for (AppEntranceInspireVideoConfigVO c2 : configs) {
            if (c2.getSort() == null) {
                return false;
            }
            if (StringUtil.isBlank((CharSequence)c2.getChannelType())) {
                return false;
            }
            if (InspireVideoChannelEnum.BXM.getCode().equalsIgnoreCase(c2.getChannelType()) || !StringUtil.isBlank((CharSequence)c2.getChannelApplicationId()) && !StringUtil.isBlank((CharSequence)c2.getChannelPositionId()) && c2.getStatus() != null) continue;
            return false;
        }
        List androidList = configs.stream().filter(c -> c.getOsType() == 1).map(c -> c.getChannelType()).collect(Collectors.toList());
        HashSet androidSet = new HashSet(androidList);
        List iosList = configs.stream().filter(c -> c.getOsType() == 2).map(c -> c.getChannelType()).collect(Collectors.toList());
        HashSet iosSet = new HashSet(iosList);
        return androidList.size() == androidSet.size() && iosList.size() == iosSet.size();
    }
}

