/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.activites.facade.service.ActivityBackService;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.adsmedia.provider.ProviderFacadeIntegration;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.ProvideLastLoginIpVo;
import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import com.bxm.adsmanager.service.adsmedia.ProviderFinanceService;
import com.bxm.adsmanager.service.adsmedia.ProviderService;
import com.bxm.adsmanager.service.media.MediaService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.provider.FirstProviderAuditDto;
import com.bxm.adsmedia.facade.model.provider.ProviderFinanceListRO;
import com.bxm.adsmedia.facade.model.provider.ProviderStatusListRO;
import com.bxm.adsmedia.facade.model.provider.SimulateLoginVo;
import com.bxm.adsmedia.facade.model.provider.SimulateRegisterDTO;
import com.bxm.util.MD5Util;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/provider"})
public class ProviderController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ProviderController.class);
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ProviderFinanceService providerFinanceService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private TblAdTagService tblAdTagService;
    @Autowired
    private ActivityBackService activityBackService;
    @Autowired
    private AdPositionAuditService adPositionAuditService;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private ProviderFacadeIntegration providerFacadeIntegration;

    @RequestMapping(value={"/getAuditPage"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProviderFinanceListRO>> getAuditPage(@RequestParam(name="keywords", required=false) String keywords, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="id", required=false, defaultValue="-1") long providerId, @RequestParam(name="status", required=false) Byte status, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(name="areaType", required=false) Integer areaType, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        boolean isFk = user.getRoleCodes() != null && user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode());
        return ResultModelFactory.SUCCESS((Serializable)this.providerFinanceService.getAuditPage(isFk, keywords, mjCode, null, providerId, status, areaType, pageNum, pageSize));
    }

    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    public ResultModel<Boolean> audit(@RequestParam(name="providerId") Long providerId, @RequestParam(name="auditPass") Boolean auditPass, @RequestParam(name="refuseReason") String refuseReason, @RequestParam(name="reviewRefuseIds", required=false, defaultValue="") String reviewRefuseIds, HttpServletRequest request, HttpServletResponse response) {
        boolean isRiskController;
        if (auditPass == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u901a\u8fc7\u6216\u62d2\u7edd");
        }
        User user = this.getUser(request, response);
        List roleCodes = user.getRoleCodes();
        if (CollectionUtils.isEmpty((Collection)roleCodes)) {
            throw new BusinessException("\u6682\u65e0\u5ba1\u6838\u6743\u9650");
        }
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.MJ.getCode()) || roleCodes.contains(RoleEnum.MJLEADER.getCode())) {
            isRiskController = false;
        } else {
            throw new BusinessException("\u6682\u65e0\u5ba1\u6838\u6743\u9650");
        }
        return ResultModelFactory.SUCCESS((Serializable)this.providerFinanceService.audit(isRiskController, providerId, auditPass, refuseReason, reviewRefuseIds, this.getUser(request, response).getUsername()));
    }

    @RequestMapping(value={"/setMj"}, method={RequestMethod.POST})
    public ResultModel<Boolean> setMj(@RequestParam(name="providerId") Long providerId, @RequestParam(name="mjCode") String mjCode, HttpServletRequest request, HttpServletResponse response) {
        return ResultModelFactory.SUCCESS((Serializable)this.providerService.setMj(providerId, mjCode, this.getUser(request, response).getUsername()));
    }

    @RequestMapping(value={"/getAuditStatusPage"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProviderStatusListRO>> getAuditStatusPage(@RequestParam(name="providerName", required=false) String providerName, @RequestParam(name="email", required=false) String email, @RequestParam(name="financeStatus", required=false) Byte financeStatus, @RequestParam(name="mediaStatus", required=false) Byte mediaStatus, @RequestParam(name="appEntranceStatus", required=false) Byte appEntranceStatus, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="bdCode", required=false) String bdCode, @RequestParam(name="isOrderByDateDesc", required=false) Boolean isOrderByDateDesc, @RequestParam(name="code", required=false, defaultValue="") String code, @RequestParam(name="areaType", required=false) Integer areaType, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        Boolean look_all;
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!(look_all = Boolean.valueOf(user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) || user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode()))).booleanValue()) {
            mjCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS((Serializable)this.providerFinanceService.getAuditStatusPage(user, providerName, email, financeStatus, mediaStatus, appEntranceStatus, mjCode, bdCode, isOrderByDateDesc, code, areaType, pageNum, pageSize));
    }

    @RequestMapping(value={"/firstAudit"}, method={RequestMethod.POST})
    public ResultModel<Boolean> firstAudit(@RequestParam(name="providerId") Long providerId, @RequestParam(name="auditPass") Boolean auditPass, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isRiskController;
        if (auditPass == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u901a\u8fc7\u6216\u62d2\u7edd");
        }
        User user = this.getUser(request, response);
        List roleCodes = user.getRoleCodes();
        if (roleCodes == null || roleCodes.size() == 0) {
            throw new BusinessException("\u6682\u65e0\u5ba1\u6838\u6743\u9650");
        }
        if (roleCodes.contains(RoleEnum.RISK_CONTROL.getCode())) {
            isRiskController = true;
        } else if (roleCodes.contains(RoleEnum.MJ.getCode()) || roleCodes.contains(RoleEnum.MJLEADER.getCode())) {
            isRiskController = false;
        } else {
            throw new BusinessException("\u6682\u65e0\u5ba1\u6838\u6743\u9650");
        }
        FirstProviderAuditDto firstProviderAuditDto = this.providerFinanceService.firstAudit(providerId, auditPass, this.getUser(request, response).getUsername(), isRiskController);
        return ResultModelFactory.SUCCESS((Serializable)this.adPositionAuditService.auditPassDataHandle(firstProviderAuditDto, isRiskController, auditPass));
    }

    @RequestMapping(value={"/getProvideLastLoginIpInfo"}, method={RequestMethod.POST})
    public ResultModel<List<ProvideLastLoginIpVo>> getProvideLastLoginIpInfo(@RequestParam(name="appKey") String appKey, HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(true);
        resultModel.setErrorDesc("\u6210\u529f");
        resultModel.setReturnValue((Object)this.providerService.getProvideLastLoginIpInfo(appKey));
        return resultModel;
    }

    @RequestMapping(value={"/set/mj-bd"}, method={RequestMethod.POST})
    public ResultModel<Boolean> setMjAndBd(@RequestParam(name="providerId") Long providerId, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="bdCode", required=false) String bdCode, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        if (!user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode()) && !user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode())) {
            throw new BusinessException("\u6682\u65e0\u64cd\u4f5c\u6743\u9650\uff01");
        }
        if (StringUtils.isBlank((CharSequence)mjCode) && StringUtils.isBlank((CharSequence)bdCode)) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u9009\u9879");
        }
        return ResultModelFactory.SUCCESS((Serializable)this.providerService.setMjAndBd(providerId, mjCode, bdCode, user.getUsername()));
    }

    @RequestMapping(value={"/set/tags"}, method={RequestMethod.POST})
    public ResultModel<Boolean> setTags(@RequestParam(name="providerId") Long providerId, @RequestParam(name="tags") String tags, HttpServletRequest request, HttpServletResponse response) {
        if (tags == null) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u6807\u7b7e");
        }
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.EMPTY_LIST);
        }
        if (!user.getRoleCodes().contains(RoleEnum.PING_TAI_YUN_YING_LEADER.getCode()) && !user.getRoleCodes().contains(RoleEnum.RISK_CONTROL.getCode())) {
            throw new BusinessException("\u6682\u65e0\u64cd\u4f5c\u6743\u9650\uff01");
        }
        return ResultModelFactory.SUCCESS((Serializable)this.providerService.setTags(providerId, tags, user.getUsername()));
    }

    @RequestMapping(value={"/findProviders"}, method={RequestMethod.GET})
    public ResultModel findProviders(@RequestParam(value="appKeys") String appKeys) {
        if (StringUtils.isBlank((CharSequence)appKeys)) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u586b\u5199\u53c2\u6570");
        }
        List adMedia = this.mediaService.queryMediaByAppKeys(appKeys);
        ResultModel resultModel = new ResultModel();
        resultModel.setSuccessed(true);
        resultModel.setErrorDesc("\u6210\u529f");
        resultModel.setReturnValue((Object)adMedia);
        return resultModel;
    }

    @RequestMapping(value={"/simulateLogin"}, method={RequestMethod.GET})
    public ResultModel simulateLogin(@RequestParam(value="developerId") Long developerId) {
        if (null == developerId) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u586b\u5199\u53c2\u6570");
        }
        SimulateLoginVo simulateLoginVo = this.providerFacadeIntegration.simulateLogin(developerId);
        if (simulateLoginVo != null) {
            ResultModel resultModel = new ResultModel();
            resultModel.setSuccessed(true);
            resultModel.setErrorDesc("\u6210\u529f");
            resultModel.setReturnValue((Object)simulateLoginVo);
            return resultModel;
        }
        return ResultModelFactory.FAIL500((String)"\u767b\u9646\u5f02\u5e38");
    }

    @RequestMapping(value={"/simulateRegister"}, method={RequestMethod.POST})
    public ResultModel simulateRegister(SimulateRegisterDTO simulateRegisterDTO) throws Exception {
        if (null == simulateRegisterDTO) {
            return ResultModelFactory.FAIL400((String)"\u8bf7\u586b\u5199\u53c2\u6570");
        }
        simulateRegisterDTO.setPwd(MD5Util.md5((String)simulateRegisterDTO.getPwd()));
        ResultModel resultModel = this.providerFacadeIntegration.simulateRegister(simulateRegisterDTO);
        if (resultModel == null) {
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5f02\u5e38");
        }
        return resultModel;
    }

    @RequestMapping(value={"/getAdvanceProviderList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProviderFinanceListRO>> getAdvanceProviderList(@RequestParam(name="keywords", required=false) String keywords, @RequestParam(name="mjCode", required=false) String mjCode, @RequestParam(name="id", required=false, defaultValue="-1") long providerId, @RequestParam(name="status", required=false) Byte status, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="areaType", required=false) Integer areaType, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user.getRoleCodes() == null) {
            user.setRoleCodes(Collections.emptyList());
        }
        String bdCode = null;
        if (user.getRoleCodes().contains(RoleEnum.BD.getCode()) && !user.getRoleCodes().contains(RoleEnum.MJLEADER.getCode())) {
            bdCode = user.getUsername();
        }
        return ResultModelFactory.SUCCESS((Serializable)this.providerFinanceService.getAuditPage(true, keywords, mjCode, bdCode, providerId, status, areaType, pageNum, pageSize));
    }
}

