/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adticketgroup;

import com.bxm.adsmanager.model.dao.adticketgroup.AppkeyGroupConfig;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.adticketgroup.AppkeyGroupService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppkeyGroupController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AppkeyGroupController.class);
    @Autowired
    AppkeyGroupService appkeyGroupService;

    @RequestMapping(value={"/appkeyGroup/findByAppkey"}, produces={"application/json"})
    public ResultModel<AppkeyGroupConfig> findByAppkey(@RequestParam(value="appkey") String appkey) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.appkeyGroupService.findByAppkey(appkey));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u7ec4\u5f00\u53d1\u8005\u67e5\u627e\u51fa\u9519system error" + e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/appkeyGroup/saveOrUpdate"}, produces={"application/json"})
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value="id", required=false) Long id, @RequestParam(value="groupIds") String groupIds, @RequestParam(value="appkey") String appkey, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            this.appkeyGroupService.saveOrUpdate(id, groupIds, appkey, user.getUsername());
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u7ec4\u5f00\u53d1\u8005\u67e5\u627e \u65b0\u589e\u6216\u8005\u4fee\u6539\u51fa\u9519system error" + e.getMessage());
        }
        return rs;
    }
}

