/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adticketgroup;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.common.Dictionaries;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.enums.TicketGroupFrequencyEnum;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TicketGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGroupController.class);
    @Autowired
    TicketGroupService ticketGroupService;

    @GetMapping(value={"/ticketgroup"}, produces={"application/json"})
    public ResultModel<PageInfo<TicketGroupVo>> findTicketGroup(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="sortName", required=false, defaultValue="modifyTime") String sortName, @RequestParam(value="sortType", required=false, defaultValue="desc") String sortType) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.ticketGroupService.findTicketGroup(keyword, status, pageNum, pageSize, sortName, sortType));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/ticketgroup/get"}, produces={"application/json"})
    public ResultModel<TicketGroupVo> findTicketGroupById(@Param(value="id") Long id) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.ticketGroupService.findTicketGroupById(id));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/ticketgroup/ticket"}, produces={"application/json"})
    public ResultModel<PageInfo<TicketVo>> findTicket(@RequestParam(value="groupId", required=false) Long groupId, @RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="ticketIdArray", required=false) String ticketIdArray, @RequestParam(value="type", defaultValue="link") String type, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        ResultModel rs = new ResultModel();
        try {
            List ticketIds = new ArrayList();
            if (StringUtil.isNotEmpty((CharSequence)ticketIdArray)) {
                ticketIds = JSON.parseArray((String)ticketIdArray, Long.class);
            }
            if ("link".equalsIgnoreCase(type) && ticketIds.isEmpty()) {
                PageInfo ticketVoPageInfo = new PageInfo();
                ticketVoPageInfo.setPageSize(pageSize.intValue());
                ticketVoPageInfo.setPageNum(pageNum.intValue());
                rs.setReturnValue((Object)ticketVoPageInfo);
            } else {
                rs.setReturnValue((Object)this.ticketGroupService.findTicket(groupId, keyword, ticketIds, type, pageNum, pageSize));
            }
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/ticketgroup", keyName="\u65b0\u589e\u6216\u8005\u66f4\u65b0\u5e7f\u544a\u7ec4")
    @PostMapping(value={"/ticketgroup"}, produces={"application/json"})
    public ResultModel<Boolean> saveOrUpdateTicketGroup(HttpServletRequest request, HttpServletResponse response, TicketGroupVo ticketGroupvo, @RequestParam(value="ticketIdArray", required=false) String ticketIdArray) {
        ResultModel rs = new ResultModel();
        try {
            List ticketIds = new ArrayList();
            if (StringUtil.isNotEmpty((CharSequence)ticketIdArray)) {
                ticketIds = JSON.parseArray((String)ticketIdArray, Long.class);
            }
            this.ticketGroupService.saveOrUpdateTicketGroup(ticketGroupvo, ticketIds, this.getUserName(request, response));
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/ticketgroup/delete", keyName="\u903b\u8f91\u5220\u9664\u5e7f\u544a\u7ec4")
    @PostMapping(value={"/ticketgroup/delete"}, produces={"application/json"})
    public ResultModel<Boolean> deleteTicketGroup(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        ResultModel rs = new ResultModel();
        try {
            boolean b = this.ticketGroupService.deleteTicketGroup(id, this.getUserName(request, response));
            rs.setReturnValue((Object)b);
            if (!b) {
                rs.setErrorDesc("\u5f00\u542f\u72b6\u6001\u7684\u5e7f\u544a\u7ec4\u4e0d\u80fd\u5220\u9664");
            }
            rs.setSuccessed(b);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @LogBefore(operType="/ticketgroup/changestatus", keyName="\u4fee\u6539\u5e7f\u544a\u7ec4\u7684\u72b6\u6001")
    @PostMapping(value={"/ticketgroup/changestatus"}, produces={"application/json"})
    public ResultModel<Boolean> changeTicketStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id, @RequestParam(value="status") Integer status) {
        ResultModel rs = new ResultModel();
        try {
            this.ticketGroupService.changeTicketStatus(id, status, this.getUserName(request, response));
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/ticketgroup/frequencycode"}, produces={"application/json"})
    public ResultModel<List<Dictionaries>> getTicketGroupFrequencyCode() {
        ResultModel rs = new ResultModel();
        try {
            Map allState = TicketGroupFrequencyEnum.getAllState();
            ArrayList list = new ArrayList();
            if (!allState.isEmpty()) {
                allState.forEach((k, v) -> {
                    Dictionaries dictionaries = new Dictionaries();
                    dictionaries.setTypecode(k.toString());
                    dictionaries.setTypename(v);
                    list.add(dictionaries);
                });
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    private String getUserName(HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        if (user == null) {
            return "\u7528\u6237\u4e0d\u660e";
        }
        return user.getUsername();
    }

    @GetMapping(value={"/ticketgroup/findByIds"}, produces={"application/json"})
    public ResultModel<PageInfo<TicketGroupVo>> findTicketGroup(@RequestParam(value="groupIds", required=false) String groupIds, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.ticketGroupService.findByIds(groupIds, pageNum, pageSize, keywords));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }
}

