/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adticketgroup;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketGroupWhiteVo;
import com.bxm.adsmanager.service.adticketgroup.TicketGroupWhiteService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TicketGroupWhiteController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TicketGroupWhiteController.class);
    @Autowired
    TicketGroupWhiteService ticketGroupWhiteService;

    @GetMapping(value={"/whitegroup"}, produces={"application/json"})
    public ResultModel<PageInfo<TicketGroupWhiteVo>> findWhiteGroup(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="isShare", required=false) Integer isShare, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.ticketGroupWhiteService.findWhiteGroup(keywords, isShare, pageNum, pageSize));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value={"/whitegroup/findByIds"}, produces={"application/json"})
    public ResultModel<PageInfo<TicketGroupWhiteVo>> findWhitegroupByIds(@RequestParam(value="groupIds", required=false) String groupIds, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        ResultModel rs = new ResultModel();
        try {
            rs.setReturnValue((Object)this.ticketGroupWhiteService.findByIds(groupIds, pageNum, pageSize, keywords));
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @RequestMapping(value={"/whitegroup/saveOrUpdate"}, produces={"application/json"})
    public ResultModel<Boolean> saveOrUpdate(TicketGroupWhiteVo ticketGroupWhiteVo, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            this.ticketGroupWhiteService.saveOrUpdate(ticketGroupWhiteVo, user.getUsername());
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u7ec4\u5f00\u53d1\u8005\u67e5\u627e \u65b0\u589e\u6216\u8005\u4fee\u6539\u51fa\u9519system error" + e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/whitegroup/delete"}, produces={"application/json"})
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value="ids", required=false) String ids, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            this.ticketGroupWhiteService.delete(ids, user.getUsername());
            rs.setReturnValue((Object)true);
            rs.setSuccessed(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u5e7f\u544a\u7ec4\u5f00\u53d1\u8005\u67e5\u627e \u65b0\u589e\u6216\u8005\u4fee\u6539\u51fa\u9519system error" + e.getMessage());
        }
        return rs;
    }
}

