/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adticketpopup;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.AdTicketNameDto;
import com.bxm.adsmanager.model.dto.AdTicketPopupDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.service.adticketpopup.AdTicketPopupService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicketPopup"})
public class AdTicketPopupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketPopupController.class);
    @Autowired
    private AdTicketPopupService adTicketPopupService;
    @Autowired
    private AdPositionService adPositionService;

    @LogBefore(operType="/adTicketPopup/add", keyName="\u793c\u5238\u5f39\u7a97")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketPopupDto adTicketPopupDto) {
        try {
            if (BeanValidator.validateGroup((Object)adTicketPopupDto, (Class[])new Class[]{AdTicketPopupDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adTicketPopupDto, (Class[])new Class[]{AdTicketPopupDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.adTicketPopupService.add(adTicketPopupDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (PushProdException p) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adTicketPopup/findAll", keyName="\u793c\u5238\u5f39\u7a97")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response, AdTicketPopupDto adTicketPopupDto) {
        try {
            ResultModel rs = new ResultModel();
            Pagination result = this.adTicketPopupService.findAll(adTicketPopupDto);
            if (result != null) {
                rs.setReturnValue((Object)result);
            } else {
                rs.setReturnValue((Object)new Pagination());
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adTicketPopup/findByPositionId", keyName="\u5355\u4e2a\u5165\u53e3\u7684\u793c\u5238\u5f39\u7a97")
    @RequestMapping(value={"/findByPositionId"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<AdTicketNameDto>> findByPositionId(HttpServletRequest request, HttpServletResponse response, String positionId) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adTicketPopupService.findByPositionId(positionId);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519");
            return rs;
        }
    }

    @LogBefore(operType="/adTicketPopup/findTicketPoputReport", keyName="\u793c\u5238\u62a5\u8868")
    @RequestMapping(value={"/findTicketPoputReport"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<AdTicketNameDto>> findTicketPoputReport(HttpServletRequest request, HttpServletResponse response, String positionId) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adTicketPopupService.findByPositionId(positionId);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u67e5\u627e\u5355\u4e2a\u5165\u53e3\u7684\u5f39\u7a97\u5238\u5217\u8868\u51fa\u9519");
            return rs;
        }
    }
}

