/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.dal.mapper.advertiser.AdvertiserBehaviorConfigMapper;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserNewDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserVo;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.advertiser.AdvertiserBehaviorConfig;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.diysite.SiteInstanceService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiserManage"})
public class AdvertiserController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserController.class);
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private SiteInstanceService siteInstanceService;
    @Autowired
    private AdvertiserBehaviorConfigMapper advertiserBehaviorConfigMapper;
    @Autowired
    private TblAdQualifyMapperExt adQualifyMapperExt;

    @RequestMapping(value={"/queryAdvertiser"}, method={RequestMethod.GET})
    public ResultModel<Pagination> queryAdvertiser(HttpServletRequest request, HttpServletResponse response, AdvertiserNewDto advertiserNewDto) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isAe((User)user))) {
                if (StringUtils.isNotEmpty((CharSequence)advertiserNewDto.getAe()) && !UserRoleCodeUtil.isAe((User)user).equals(advertiserNewDto.getAe())) {
                    rs.setReturnValue((Object)new Pagination());
                    return rs;
                }
                advertiserNewDto.setAe(user.getUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isSale((User)user))) {
                if (StringUtils.isNotEmpty((CharSequence)advertiserNewDto.getSale()) && !UserRoleCodeUtil.isSale((User)user).equals(advertiserNewDto.getSale())) {
                    rs.setReturnValue((Object)new Pagination());
                    return rs;
                }
                advertiserNewDto.setSale(user.getUsername());
            }
            Pagination advertiserList = this.adShopIntegration.getAdvertiserList(advertiserNewDto);
            this.fillAudit(advertiserList);
            rs.setReturnValue((Object)advertiserList);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    private void fillAudit(Pagination advertiserList) {
        List list = advertiserList.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List ids = list.stream().map(a -> a.getId() == null ? -99L : a.getId().longValue()).collect(Collectors.toList());
        List qualifys = this.adQualifyMapperExt.getQualifyByAdvertiserIds(ids);
        for (AdvertiserVo advertiserVo : list) {
            StringBuffer qualifyAuditDescBuffer = new StringBuffer();
            Long id = advertiserVo.getId().longValue();
            Map<Integer, Long> qualifyGroupByStatus = qualifys.stream().filter(q -> q.getAdvertiserId().equals(id)).collect(Collectors.groupingBy(TblAdQualify::getAuditStatus, Collectors.counting()));
            qualifyGroupByStatus.forEach((status, count) -> {
                switch (status) {
                    case 1: {
                        qualifyAuditDescBuffer.append("\u5ba1\u6838\u901a\u8fc7\uff1a").append(count).append(" \uff1b");
                        break;
                    }
                    case 2: {
                        qualifyAuditDescBuffer.append("\u5f85\u5ba1\u6838\uff1a").append(count).append(" \uff1b");
                        break;
                    }
                    case 3: {
                        qualifyAuditDescBuffer.append("\u5ba1\u6838\u62d2\u7edd\uff1a").append(count).append(" \uff1b");
                    }
                }
            });
            advertiserVo.setQualifyStatus(qualifyAuditDescBuffer.toString());
        }
    }

    @LogBefore(operType="/advertiserManage/updateAdvertiser", keyName="\u5e7f\u544a\u4e3b")
    @RequestMapping(value={"/updateAdvertiser"}, method={RequestMethod.PUT})
    @Transactional
    public ResultModel<Integer> updateAdvertiser(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Integer id, AdvertiserNewDto advertiserNewDto) {
        ResultModel rs = new ResultModel();
        try {
            boolean needUpdateBehaviorConfig;
            advertiserNewDto.setId(id);
            boolean flag = this.adShopIntegration.updateAdShopMsg(advertiserNewDto);
            this.advertiserBehaviorConfigMapper.deleteByAdvertiserId(advertiserNewDto.getId());
            boolean bl = needUpdateBehaviorConfig = StringUtils.isNotBlank((CharSequence)advertiserNewDto.getBehaviorConfig()) || advertiserNewDto.getDisplayValidClick() != null || Objects.nonNull(advertiserNewDto.getCustomize());
            if (needUpdateBehaviorConfig) {
                AdvertiserBehaviorConfig insert = new AdvertiserBehaviorConfig();
                insert.setAdvertiserId(advertiserNewDto.getId());
                insert.setBehaviorNameConfig(advertiserNewDto.getBehaviorConfig());
                insert.setDisplayValidClick(advertiserNewDto.getDisplayValidClick());
                insert.setCustomize(advertiserNewDto.getCustomize());
                this.advertiserBehaviorConfigMapper.insertSelective(insert);
            }
            if (flag) {
                rs.setReturnValue((Object)1);
                rs.setSuccessed(true);
            } else {
                rs.setReturnValue((Object)0);
                rs.setSuccessed(false);
            }
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @LogBefore(operType="/advertiserManage/updatePassword", keyName="\u5e7f\u544a\u4e3b")
    @RequestMapping(value={"/updatePassword"}, method={RequestMethod.PUT})
    public ResultModel updatePassword(AdvertiserNewDto advertiserNewDto, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        User user = this.getUser(request, response);
        Boolean isLeader = UserRoleCodeUtil.isLeader((User)user);
        if (!isLeader.booleanValue()) {
            return ResultModelFactory.FAIL500((String)"\u65e0\u4fee\u6539\u6743\u9650");
        }
        AdvertiserNewDto advertiserNewDtoTemp = new AdvertiserNewDto();
        advertiserNewDtoTemp.setId(advertiserNewDto.getId());
        advertiserNewDtoTemp.setPassword(advertiserNewDto.getPassword());
        if (StringUtils.isEmpty((CharSequence)advertiserNewDto.getPassword())) {
            return ResultModelFactory.FAIL500((String)"\u65b0\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(advertiserNewDto.getId().longValue());
            advertiserNewDtoTemp.setCompany(advertiserDto.getCompany());
            boolean flag = this.adShopIntegration.updateAdShopMsg(advertiserNewDtoTemp);
            if (flag) {
                rs.setReturnValue((Object)true);
                rs.setSuccessed(true);
            } else {
                rs.setReturnValue((Object)false);
                rs.setSuccessed(false);
            }
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/setOwnSite"}, method={RequestMethod.POST})
    public ResultModel setOwnSite(@RequestParam(name="advertiserId") Integer advertiserId, @RequestParam(name="ownSite") String ownSite) {
        ResultModel resultModel = new ResultModel();
        Boolean result = this.siteInstanceService.setOwnSite(advertiserId, ownSite);
        resultModel.setReturnValue((Object)result);
        return resultModel;
    }

    @RequestMapping(value={"/getAdvertiserBehaviourConfig"}, method={RequestMethod.GET})
    public ResultModel getAdvertiserBehaviourConfig(@RequestParam(value="advertiserId") Integer advertiserId) {
        ResultModel rs = new ResultModel();
        AdvertiserBehaviorConfig advertiserBehaviorConfig = this.advertiserBehaviorConfigMapper.selectByAdvertiserId(advertiserId);
        if (null != advertiserBehaviorConfig) {
            rs.setReturnValue((Object)advertiserBehaviorConfig);
        }
        return rs;
    }
}

