/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.model.dto.advertiser.UpdateStationUserWeightDTO;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightDetailVO;
import com.bxm.adsmanager.model.vo.advertiser.TblStationUserWeightVO;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.advertiser.TblStationUserWeightService;
import com.bxm.adsmanager.service.advertiser.context.StationUserWeightContext;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stationUserWeight"})
public class StationUserWeightController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(StationUserWeightController.class);
    @Autowired
    private TblStationUserWeightService tblStationUserWeightService;
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public void test(@RequestParam(name="ticketId", required=false) Long ticketId) {
        this.adIncomeTicketService.updatePositionTicketWeight(ticketId, ticketId);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    public void check() {
        this.tblStationUserWeightService.check();
    }

    @RequestMapping(value={"/getPage"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<TblStationUserWeightVO>> getList(@RequestParam(name="advertiserNameOrId", required=false) String advertiserNameOrId, @RequestParam(name="saleCode", required=false) String saleCode, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="20") Integer pageSize) {
        return ResultModelFactory.SUCCESS((Serializable)this.tblStationUserWeightService.getPage(advertiserNameOrId, saleCode, pageNum, pageSize));
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public ResultModel<TblStationUserWeightDetailVO> detail(@RequestParam(name="id") Long id) {
        return ResultModelFactory.SUCCESS((Serializable)this.tblStationUserWeightService.detail(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(operType="/stationUserWeight/add", keyName="\u589e\u52a0\u7ad9\u5185\u6237\u6743\u91cd")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel<Boolean> add(UpdateStationUserWeightDTO dto, HttpServletRequest request, HttpServletResponse response) {
        ConstraintViolation constraintViolation = BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{UpdateStationUserWeightDTO.Add.class});
        if (constraintViolation != null) {
            return ResultModelFactory.FAIL400((String)constraintViolation.getMessage());
        }
        dto.setOperationUserName(super.getUser(request, response).getUsername());
        try {
            ResultModel resultModel = ResultModelFactory.SUCCESS((Serializable)this.tblStationUserWeightService.add(dto));
            return resultModel;
        }
        finally {
            StationUserWeightContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(operType="/stationUserWeight/update", keyName="\u4fee\u6539\u7ad9\u5185\u6237\u6743\u91cd")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel<Boolean> update(UpdateStationUserWeightDTO dto, HttpServletRequest request, HttpServletResponse response) {
        ConstraintViolation constraintViolation = BeanValidator.validateGroup((Object)dto, (Class[])new Class[]{UpdateStationUserWeightDTO.Update.class});
        if (constraintViolation != null) {
            return ResultModelFactory.FAIL400((String)constraintViolation.getMessage());
        }
        dto.setOperationUserName(super.getUser(request, response).getUsername());
        try {
            ResultModel resultModel = ResultModelFactory.SUCCESS((Serializable)this.tblStationUserWeightService.update(dto));
            return resultModel;
        }
        finally {
            StationUserWeightContext.remove();
        }
    }
}

